/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.cagerium;

import net.mehvahdjukaar.cagerium.common.CageItem;
import net.mehvahdjukaar.cagerium.common.CageriumBlock;
import net.mehvahdjukaar.cagerium.common.CageriumBlockTile;
import net.mehvahdjukaar.cagerium.common.SkeletonKeyItem;
import net.mehvahdjukaar.cagerium.common.SpawnEggShapedRecipe;
import net.mehvahdjukaar.cagerium.common.Tier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="cagerium")
public class Cagerium {
    public static final String MOD_ID = "cagerium";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final TagKey<EntityType<?>> BOSSES = TagKey.m_203882_((ResourceKey)Registry.f_122903_, (ResourceLocation)Cagerium.res("bosses"));
    public static final TagKey<EntityType<?>> BLACKLIST = TagKey.m_203882_((ResourceKey)Registry.f_122903_, (ResourceLocation)Cagerium.res("cagerium_blacklist"));
    private static final DeferredRegister<RecipeSerializer<?>> RECIPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"cagerium");
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"cagerium");
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"cagerium");
    private static final DeferredRegister<BlockEntityType<?>> TILES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITIES, (String)"cagerium");
    public static ForgeConfigSpec SERVER_SPEC;
    public static ForgeConfigSpec.IntValue TICKS_TO_DROP_LOOT_0;
    public static ForgeConfigSpec.IntValue TICKS_TO_DROP_LOOT_1;
    public static ForgeConfigSpec.IntValue TICKS_TO_DROP_LOOT_2;
    public static final RegistryObject<RecipeSerializer<?>> UPGRADE_RECIPE;
    public static final String CAGE_NAME = "cage";
    public static final RegistryObject<Block> CAGE;
    public static final RegistryObject<Item> CAGE_ITEM;
    public static final RegistryObject<Item> CAGE_KEY;
    public static final RegistryObject<Item> CAGE_BASE;
    public static final String TERRARIUM_NAME = "terrarium";
    public static final RegistryObject<Block> TERRARIUM;
    public static final RegistryObject<Item> TERRARIUM_ITEM;
    public static final RegistryObject<Item> TERRARIUM_BASE;
    public static final String PLATE_NAME = "plate";
    public static final RegistryObject<Block> PLATE;
    public static final RegistryObject<Item> PLATE_ITEM;
    public static final RegistryObject<Item> PLATE_GEM;
    public static final RegistryObject<BlockEntityType<CageriumBlockTile>> TILE;
    public static final RegistryObject<Item> FIRE_UPGRADE;
    public static final RegistryObject<Item> IRON_GOLEM_SPAWN_EGG;
    public static final RegistryObject<Item> WITHER_SPAWN_EGG;
    public static final RegistryObject<Item> ENDER_DRAGON_SPAWN_EGG;

    public static ResourceLocation res(String n) {
        return new ResourceLocation(MOD_ID, n);
    }

    public static String str(String n) {
        return "cagerium:" + n;
    }

    public Cagerium() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCKS.register(bus);
        ITEMS.register(bus);
        TILES.register(bus);
        RECIPES.register(bus);
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        TICKS_TO_DROP_LOOT_0 = builder.defineInRange("terrarium_ticks_to_drop", 100, 1, 100000);
        TICKS_TO_DROP_LOOT_1 = builder.defineInRange("cage_ticks_to_drop", 100, 1, 100000);
        TICKS_TO_DROP_LOOT_2 = builder.defineInRange("plate_ticks_to_drop", 300, 1, 100000);
        SERVER_SPEC = builder.build();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SERVER_SPEC);
        MinecraftForge.EVENT_BUS.addListener(Cagerium::addReloadListener);
    }

    public static void addReloadListener(AddReloadListenerEvent event) {
    }

    static {
        UPGRADE_RECIPE = RECIPES.register("spawn_egg_shaped", SpawnEggShapedRecipe.Serializer::new);
        CAGE = BLOCKS.register(CAGE_NAME, () -> new CageriumBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76404_).m_60913_(3.0f, 6.0f).m_60971_((s, p, l) -> false).m_60955_().m_60924_((s, p, l) -> false).m_60918_(SoundType.f_56743_), Tier.MOBS));
        CAGE_ITEM = ITEMS.register(CAGE_NAME, () -> new CageItem((Block)CAGE.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40750_).m_41497_(Rarity.RARE)));
        CAGE_KEY = ITEMS.register("skeleton_key", () -> new SkeletonKeyItem(new Item.Properties().m_41491_(CreativeModeTab.f_40753_).m_41497_(Rarity.RARE)));
        CAGE_BASE = ITEMS.register("ominous_skull", () -> new Item(new Item.Properties().m_41491_(CreativeModeTab.f_40759_).m_41497_(Rarity.RARE)));
        TERRARIUM = BLOCKS.register(TERRARIUM_NAME, () -> new CageriumBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76404_).m_60913_(2.0f, 4.0f).m_60971_((s, p, l) -> false).m_60955_().m_60924_((s, p, l) -> false).m_60918_(SoundType.f_56744_), Tier.PASSIVE));
        TERRARIUM_ITEM = ITEMS.register(TERRARIUM_NAME, () -> new CageItem((Block)TERRARIUM.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40750_).m_41497_(Rarity.RARE)));
        TERRARIUM_BASE = ITEMS.register("binding_wood_plate", () -> new Item(new Item.Properties().m_41491_(CreativeModeTab.f_40759_).m_41497_(Rarity.RARE)));
        PLATE = BLOCKS.register(PLATE_NAME, () -> new CageriumBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76404_).m_60913_(3.0f, 6.0f).m_60971_((s, p, l) -> false).m_60955_().m_60924_((s, p, l) -> false).m_60918_(SoundType.f_56742_), Tier.BOSSES));
        PLATE_ITEM = ITEMS.register(PLATE_NAME, () -> new CageItem((Block)PLATE.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40750_).m_41497_(Rarity.EPIC)));
        PLATE_GEM = ITEMS.register("binding_gemstone", () -> new Item(new Item.Properties().m_41491_(CreativeModeTab.f_40759_).m_41497_(Rarity.EPIC)));
        TILE = TILES.register(MOD_ID, () -> BlockEntityType.Builder.m_155273_(CageriumBlockTile::new, (Block[])new Block[]{(Block)CAGE.get(), (Block)TERRARIUM.get(), (Block)PLATE.get()}).m_58966_(null));
        FIRE_UPGRADE = ITEMS.register("burning_upgrade", () -> new Item(new Item.Properties().m_41491_(CreativeModeTab.f_40759_)));
        IRON_GOLEM_SPAWN_EGG = ITEMS.register("iron_golem_spawn_egg", () -> new ForgeSpawnEggItem(() -> EntityType.f_20460_, 0xC4C3C4, 0xFCFCFC, new Item.Properties().m_41491_(CreativeModeTab.f_40753_)));
        WITHER_SPAWN_EGG = ITEMS.register("wither_spawn_egg", () -> new ForgeSpawnEggItem(() -> EntityType.f_20496_, 0x131313, 12842728, new Item.Properties().m_41491_(CreativeModeTab.f_40753_)));
        ENDER_DRAGON_SPAWN_EGG = ITEMS.register("ender_dragon_spawn_egg", () -> new ForgeSpawnEggItem(() -> EntityType.f_20565_, 0x121212, 11021253, new Item.Properties().m_41491_(CreativeModeTab.f_40753_)));
    }
}

