/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.cagerium;

import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.mehvahdjukaar.cagerium.Cagerium;
import net.mehvahdjukaar.cagerium.client.CageBlockTileRenderer;
import net.mehvahdjukaar.cagerium.client.texture_renderer.RenderedTexturesManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="cagerium", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class CageriumClient {
    public static final ResourceLocation UPGRADE_BASE = Cagerium.res("item/upgrade_base");

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void init(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)Cagerium.CAGE.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)Cagerium.TERRARIUM.get()), (RenderType)RenderType.m_110466_());
        });
    }

    @SubscribeEvent
    public static void entityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)Cagerium.TILE.get(), CageBlockTileRenderer::new);
    }

    @SubscribeEvent
    public static void onModelRegistry(ModelRegistryEvent event) {
        ForgeModelBakery.addSpecialModel((ResourceLocation)UPGRADE_BASE);
    }

    public static void registerISTER(Consumer<IItemRenderProperties> consumer, final BiFunction<BlockEntityRenderDispatcher, EntityModelSet, BlockEntityWithoutLevelRenderer> factory) {
        consumer.accept(new IItemRenderProperties(){
            final NonNullLazy<BlockEntityWithoutLevelRenderer> renderer = NonNullLazy.of(() -> (BlockEntityWithoutLevelRenderer)factory.apply(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_()));

            public BlockEntityWithoutLevelRenderer getItemStackRenderer() {
                return (BlockEntityWithoutLevelRenderer)this.renderer.get();
            }
        });
    }

    @Mod.EventBusSubscriber(modid="cagerium", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ClientEvents {
        @SubscribeEvent
        public static void tick(TickEvent.RenderTickEvent event) {
            if (event.phase == TickEvent.Phase.END && Minecraft.m_91087_().f_91073_ != null) {
                RenderedTexturesManager.updateTextures();
            }
        }
    }
}

