/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.cagerium.client.texture_renderer;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.mehvahdjukaar.cagerium.Cagerium;
import net.mehvahdjukaar.cagerium.client.texture_renderer.DummyWorld;
import net.mehvahdjukaar.cagerium.client.texture_renderer.FrameBufferBackedDynamicTexture;
import net.mehvahdjukaar.cagerium.common.MobData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class RenderedTexturesManager {
    private static final List<RenderingData> REQUESTED_FOR_RENDERING = new ArrayList<RenderingData>();
    private static final LoadingCache<ResourceLocation, FrameBufferBackedDynamicTexture> TEXTURE_CACHE = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).removalListener(i -> {
        FrameBufferBackedDynamicTexture value = (FrameBufferBackedDynamicTexture)((Object)((Object)i.getValue()));
        if (value != null) {
            value.close();
        }
    }).build((CacheLoader)new CacheLoader<ResourceLocation, FrameBufferBackedDynamicTexture>(){

        public FrameBufferBackedDynamicTexture load(ResourceLocation key) {
            return null;
        }
    });

    public static void aaa() {
        ResourceLocation res = new ResourceLocation("ender_dragon");
        FrameBufferBackedDynamicTexture t = (FrameBufferBackedDynamicTexture)((Object)TEXTURE_CACHE.getIfPresent((Object)res));
        Minecraft.m_91087_().m_91097_().m_118495_(res, (AbstractTexture)t);
    }

    public static void clearCache() {
        TEXTURE_CACHE.invalidateAll();
    }

    @Nullable
    public static FrameBufferBackedDynamicTexture getFlatMobTexture(ResourceLocation res, int size, @Nullable Consumer<NativeImage> postProcessing) {
        FrameBufferBackedDynamicTexture texture = (FrameBufferBackedDynamicTexture)((Object)TEXTURE_CACHE.getIfPresent((Object)res));
        if (texture == null) {
            texture = new FrameBufferBackedDynamicTexture(res, size);
            TEXTURE_CACHE.put((Object)res, (Object)texture);
            Consumer<FrameBufferBackedDynamicTexture> factory = t -> {
                RenderedTexturesManager.drawEntity(t, res);
                if (postProcessing != null) {
                    t.download();
                    NativeImage img = t.getPixels();
                    postProcessing.accept(img);
                    t.upload();
                }
            };
            REQUESTED_FOR_RENDERING.add(new RenderingData(res, factory, false));
            return null;
        }
        return texture;
    }

    public static void updateTextures() {
        ListIterator<RenderingData> iter = REQUESTED_FOR_RENDERING.listIterator();
        while (iter.hasNext()) {
            RenderingData data = iter.next();
            FrameBufferBackedDynamicTexture texture = (FrameBufferBackedDynamicTexture)((Object)TEXTURE_CACHE.getIfPresent((Object)data.id));
            if (texture != null) {
                if (!texture.isInitialized()) {
                    texture.initialize();
                }
                data.textureDrawingFunction.accept(texture);
            }
            if (data.animated && texture != null) continue;
            iter.remove();
        }
    }

    public static Matrix4f getProjectionMatrix(double pFov, int size, int renderDistance) {
        PoseStack posestack = new PoseStack();
        posestack.m_85850_().m_85861_().m_27624_();
        float zoom = 1.0f;
        float zoomX = 1.0f;
        float zoomY = 1.0f;
        if (zoom != 1.0f) {
            posestack.m_85837_((double)zoomX, (double)(-zoomY), 0.0);
            posestack.m_85841_(zoom, zoom, 1.0f);
        }
        posestack.m_85850_().m_85861_().m_27644_(Matrix4f.m_27625_((double)pFov, (float)((float)size / (float)size), (float)0.05f, (float)((float)renderDistance * 4.0f)));
        return posestack.m_85850_().m_85861_();
    }

    public static void drawEntity(FrameBufferBackedDynamicTexture tex, ResourceLocation id) {
        Minecraft mc = Minecraft.m_91087_();
        RenderTarget frameBuffer = tex.getFrameBuffer();
        frameBuffer.m_83954_(Minecraft.f_91002_);
        frameBuffer.m_83947_(true);
        int size = 16;
        Matrix4f oldProjection = RenderSystem.m_157192_();
        Matrix4f matrix4f = Matrix4f.m_162203_((float)0.0f, (float)size, (float)0.0f, (float)size, (float)1000.0f, (float)3000.0f);
        RenderSystem.m_157425_((Matrix4f)matrix4f);
        PoseStack posestack = RenderSystem.m_157191_();
        posestack.m_85836_();
        posestack.m_166856_();
        posestack.m_85837_(0.0, 0.0, -2000.0);
        RenderSystem.m_157182_();
        Lighting.m_84931_();
        MobData data = MobData.getOrCreate(id, (Level)DummyWorld.INSTANCE, BlockPos.f_121853_);
        if (data != null) {
            if (data.getEntity() == null) {
                Cagerium.LOGGER.warn("Trying to render null entity for cagerium upgrade. skipping");
                return;
            }
            posestack.m_85836_();
            RenderSystem.m_69478_();
            RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            PoseStack pose = RenderSystem.m_157191_();
            pose.m_85836_();
            pose.m_85837_(0.0, 0.0, 100.0);
            pose.m_85837_(8.0, 8.0, 0.0);
            pose.m_85841_(16.0f, -16.0f, 16.0f);
            RenderSystem.m_157182_();
            PoseStack modelStack = new PoseStack();
            MultiBufferSource.BufferSource bs = mc.m_91269_().m_110104_();
            float yRot = 225 + (id.m_135815_().equals("ender_dragon") ? -180 : 0);
            Transformation tr = new Transformation(Vector3f.f_176763_, new Quaternion(30.0f, yRot, 0.0f, true), new Vector3f(0.625f, 0.625f, 0.625f), null);
            tr.push(modelStack);
            float s = data.getScale(0);
            float y = data.getYOffset(0);
            modelStack.m_85837_(0.0, (double)y - 0.5, 0.0);
            modelStack.m_85845_(Vector3f.f_122224_.m_122240_(180.0f));
            modelStack.m_85841_(s *= 1.3333334f, s, s);
            Lighting.m_84930_();
            EntityRenderer renderer = mc.m_91290_().m_114382_(data.getEntity());
            renderer.m_7392_(data.getEntity(), 0.0f, 1.0f, modelStack, (MultiBufferSource)bs, 0xF000F0);
            bs.m_109911_();
            RenderSystem.m_69482_();
            posestack.m_85849_();
            RenderSystem.m_157182_();
            posestack.m_85849_();
        }
        posestack.m_85849_();
        RenderSystem.m_157182_();
        RenderSystem.m_157425_((Matrix4f)oldProjection);
        mc.m_91385_().m_83947_(true);
    }

    private record RenderingData(ResourceLocation id, Consumer<FrameBufferBackedDynamicTexture> textureDrawingFunction, boolean animated) {
    }
}

