/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.cagerium.common;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.mehvahdjukaar.cagerium.common.Tier;
import net.mehvahdjukaar.cagerium.mixins.FoxInvoker;
import net.mehvahdjukaar.cagerium.mixins.SlimeInvoker;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.Level;

public class MobData {
    public static ThreadLocal<LoadingCache<ResourceLocation, MobData>> MOB_CACHE = ThreadLocal.withInitial(() -> CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<ResourceLocation, MobData>(){

        public MobData load(ResourceLocation key) {
            return null;
        }
    }));
    private final Entity entity;
    private final Pair<Float, Float> fullDimensions;
    private final Pair<Float, Float> middleDimensions;
    private final Pair<Float, Float> halfDimensions;

    public static MobData getOrCreate(EntityType<?> type, Level level, BlockPos pos) {
        Mth.m_14057_((Vec3i)pos);
        return MobData.getOrCreate(type.getRegistryName(), level, pos);
    }

    public static MobData getOrCreate(ResourceLocation type, Level level, BlockPos pos) {
        MobData en = (MobData)MOB_CACHE.get().getIfPresent((Object)type);
        if (en != null) {
            return en;
        }
        Optional entity = Registry.f_122826_.m_6612_(type);
        if (entity.isPresent()) {
            MobData m = MobData.create((EntityType)entity.get(), level);
            MOB_CACHE.get().put((Object)type, (Object)m);
            return m;
        }
        return null;
    }

    public static MobData create(EntityType<?> type, Level level) {
        LivingEntity le;
        Entity entity = type.m_20615_(level);
        if (entity instanceof LivingEntity) {
            le = (LivingEntity)entity;
            le.f_20886_ = 0.0f;
            le.f_20885_ = 0.0f;
            le.f_20924_ = 0.0f;
            le.f_20923_ = 0.0f;
            le.f_20925_ = 0.0f;
            le.f_20917_ = 0;
            le.f_20916_ = 0;
            le.f_20921_ = 0.0f;
        }
        entity.m_146922_(0.0f);
        entity.f_19859_ = 0.0f;
        entity.f_19860_ = 0.0f;
        entity.m_146926_(0.0f);
        entity.m_20095_();
        entity.f_19802_ = 0;
        if (entity instanceof Bat) {
            le = (Bat)entity;
        }
        if (entity instanceof FoxInvoker) {
            FoxInvoker foxInvoker = (FoxInvoker)entity;
            foxInvoker.invokeSetSleeping(true);
        }
        if (entity instanceof SlimeInvoker) {
            SlimeInvoker slime = (SlimeInvoker)entity;
            slime.invokeSetSize(3, false);
        }
        Pair<Float, Float> dim = MobData.calculateDimensions(entity, 0.85f, 0.8f, true);
        Pair<Float, Float> dim1 = MobData.calculateDimensions(entity, 0.55f, 0.8f, false);
        Pair<Float, Float> dim2 = MobData.calculateDimensions(entity, 0.475f, 0.7f, true);
        return new MobData(entity, dim, dim1, dim2);
    }

    public MobData(Entity entity, Pair<Float, Float> fullDimensions, Pair<Float, Float> middleDimensions, Pair<Float, Float> halfDimensions) {
        this.entity = entity;
        this.fullDimensions = fullDimensions;
        this.middleDimensions = middleDimensions;
        this.halfDimensions = halfDimensions;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public float getScale(int level) {
        return switch (level) {
            default -> ((Float)this.halfDimensions.getFirst()).floatValue();
            case 0 -> ((Float)this.fullDimensions.getFirst()).floatValue();
            case 1 -> ((Float)this.middleDimensions.getFirst()).floatValue();
        };
    }

    public float getYOffset(int level) {
        return switch (level) {
            default -> ((Float)this.halfDimensions.getSecond()).floatValue();
            case 0 -> ((Float)this.fullDimensions.getSecond()).floatValue();
            case 1 -> ((Float)this.middleDimensions.getSecond()).floatValue();
        };
    }

    private static Pair<Float, Float> calculateDimensions(Entity mob, float width, float height, boolean enlargeAnimals) {
        float yOffset;
        String name;
        LivingEntity le;
        float babyScale = 1.0f;
        if (Tier.BOSSES.acceptsEntityType(mob.m_6095_())) {
            width = (float)((double)width * 1.25);
        }
        if (mob instanceof LivingEntity && (le = (LivingEntity)mob).m_6162_()) {
            babyScale = mob instanceof Villager ? 1.125f : (mob instanceof AgeableMob ? 2.0f : 1.125f);
        }
        float scale = 1.0f;
        float w = mob.m_20205_() * babyScale;
        float h = mob.m_20206_() * babyScale;
        boolean isAir = false;
        float aW = w;
        float aH = h;
        if (enlargeAnimals && mob instanceof Animal) {
            aW *= 1.4f;
            aH *= 1.125f;
        }
        float margin = 0.125f;
        float yMargin = 0.0625f;
        float maxH = height - 2.0f * (isAir ? margin : yMargin);
        float maxW = width - 2.0f * margin;
        if (aW > maxW || aH > maxH) {
            scale = aW - maxW > aH - maxH ? maxW / aW : maxH / aH;
        }
        if ((name = mob.m_6095_().getRegistryName().toString()).equals("iceandfire:fire_dragon") || name.equals("iceandfire:ice_dragon") || name.equals("iceandfire:lightning_dragon")) {
            scale = (float)((double)scale * 0.45);
        }
        float f = yOffset = isAir ? height / 2.0f - aH * scale / 2.0f : yMargin;
        if (mob instanceof Bat) {
            yOffset *= 1.5f;
        } else if (mob instanceof EnderDragon) {
            scale *= 2.0f;
            yOffset *= 2.0f;
        } else if (mob instanceof WitherBoss) {
            scale *= 1.5f;
            yOffset = (float)((double)yOffset * 0.9125);
        }
        return Pair.of((Object)Float.valueOf(scale), (Object)Float.valueOf(yOffset));
    }
}

