/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.items.modes;

import com.direwolf20.buildinggadgets.common.items.modes.AbstractMode;
import com.direwolf20.buildinggadgets.common.tainted.building.Region;
import com.direwolf20.buildinggadgets.common.tainted.building.placement.ConnectedSurface;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;

public class SurfaceMode
extends AbstractMode {
    public SurfaceMode(boolean isExchanging) {
        super(isExchanging);
    }

    @Override
    List<BlockPos> collect(AbstractMode.UseContext context, Player player, BlockPos start) {
        int bound = context.getRange() / 2;
        Region area = new Region((Vec3i)start).expand(bound * (1 - Math.abs(context.getHitSide().m_122429_())), bound * (1 - Math.abs(context.getHitSide().m_122430_())), bound * (1 - Math.abs(context.getHitSide().m_122431_())));
        if (!context.isConnected()) {
            return area.stream().map(BlockPos::m_7949_).collect(Collectors.toList());
        }
        ArrayList<BlockPos> coords = new ArrayList<BlockPos>();
        ConnectedSurface.create(area, (BlockGetter)context.getWorld(), pos -> this.isExchanging() ? pos : pos.m_142300_(context.getHitSide().m_122424_()), start, context.getHitSide().m_122424_(), context.getRange(), context.isFuzzy()).spliterator().forEachRemaining(coords::add);
        return coords;
    }

    @Override
    public boolean validator(BlockPos pos, AbstractMode.UseContext context) {
        boolean topRow = super.validator(pos, context);
        if (this.isExchanging()) {
            return topRow;
        }
        BlockState startState = context.getWorldState(context.getStartPos());
        if (context.isFuzzy()) {
            return topRow && !context.getWorld().m_46859_(pos.m_142300_(context.getHitSide().m_122424_()));
        }
        return topRow && context.getWorld().m_8055_(pos.m_142300_(context.getHitSide().m_122424_())) == startState;
    }
}

