/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.inventory.materials.objects;

import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.objects.IUniqueObject;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.objects.IUniqueObjectSerializer;
import com.direwolf20.buildinggadgets.common.tainted.template.SerialisationSupport;
import com.direwolf20.buildinggadgets.common.util.tools.RegistryUtils;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializer;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public final class UniqueItem
implements IUniqueObject<Item> {
    private final Item item;
    @Nullable
    private final CompoundTag tagCompound;
    @Nullable
    private final CompoundTag forgeCaps;
    private final int hash;
    private final ComparisonMode tagMatch;
    private final ComparisonMode capMatch;

    public static UniqueItem ofStack(ItemStack stack) {
        CompoundTag nbt = new CompoundTag();
        stack.m_41739_(nbt);
        return new UniqueItem(stack.m_41720_(), stack.m_41783_(), ComparisonMode.EXACT_MATCH, nbt.m_128469_("ForgeCaps"), ComparisonMode.EXACT_MATCH);
    }

    public UniqueItem(Item item) {
        this(item, null, ComparisonMode.EXACT_MATCH);
    }

    public UniqueItem(Item item, @Nullable CompoundTag tagCompound, ComparisonMode comparisonMode) {
        this(item, tagCompound, comparisonMode, null, ComparisonMode.EXACT_MATCH);
    }

    public UniqueItem(Item item, @Nullable CompoundTag tagCompound, ComparisonMode tagMatch, @Nullable CompoundTag forgeCaps, ComparisonMode capMatch) {
        this.item = Objects.requireNonNull(item, "Cannot construct a UniqueItem for a null Item!");
        this.tagCompound = tagCompound;
        this.forgeCaps = forgeCaps;
        this.tagMatch = Objects.requireNonNull(tagMatch);
        this.capMatch = Objects.requireNonNull(capMatch);
        int hash = capMatch.hashCode() + 31 * tagMatch.hashCode();
        hash = tagCompound != null ? tagCompound.hashCode() + 31 * hash : hash;
        hash = forgeCaps != null ? forgeCaps.hashCode() + 31 * hash : hash;
        this.hash = Objects.requireNonNull(item.getRegistryName()).hashCode() + 31 * hash;
    }

    @Override
    public Class<Item> getIndexClass() {
        return Item.class;
    }

    @Override
    public Item getIndexObject() {
        return this.item;
    }

    @Nullable
    public CompoundTag getTag() {
        return this.tagCompound != null ? this.tagCompound.m_6426_() : null;
    }

    @Nullable
    public CompoundTag getForgeCaps() {
        return this.forgeCaps != null ? this.forgeCaps.m_6426_() : null;
    }

    @Override
    public ItemStack createStack(int count) {
        ItemStack res = new ItemStack((ItemLike)this.item, count, this.forgeCaps);
        res.m_41751_(this.tagCompound);
        return res;
    }

    @Override
    public boolean matches(ItemStack stack) {
        if (stack.m_41720_() != this.getIndexObject()) {
            return false;
        }
        if (this.tagCompound != null && !this.tagMatch.match(this.tagCompound, stack.m_41783_())) {
            return false;
        }
        if (this.forgeCaps != null) {
            CompoundTag container = new CompoundTag();
            stack.m_41739_(container);
            CompoundTag otherCapNBT = container.m_128469_("ForgeCaps");
            return this.capMatch.match(this.forgeCaps, otherCapNBT);
        }
        return true;
    }

    @Override
    public ItemStack insertInto(ItemStack stack, int count) {
        if (this.forgeCaps != null) {
            stack = new ItemStack((ItemLike)this.getIndexObject(), count, this.forgeCaps);
        } else {
            stack.m_41764_(Math.min(stack.m_41613_() + count, stack.m_41741_()));
        }
        if (this.tagCompound != null) {
            stack.m_41751_(this.tagCompound);
        }
        return stack;
    }

    @Override
    public IUniqueObjectSerializer getSerializer() {
        return SerialisationSupport.uniqueItemSerializer();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UniqueItem)) {
            return false;
        }
        UniqueItem that = (UniqueItem)o;
        if (!this.item.equals(that.item)) {
            return false;
        }
        if (this.tagCompound != null ? !this.tagCompound.equals((Object)that.tagCompound) : that.tagCompound != null) {
            return false;
        }
        if (this.forgeCaps != null ? !this.forgeCaps.equals((Object)that.forgeCaps) : that.forgeCaps != null) {
            return false;
        }
        if (this.tagMatch != that.tagMatch) {
            return false;
        }
        return this.capMatch == that.capMatch;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("item", (Object)this.getIndexObject().getRegistryName()).add("tagCompound", (Object)this.tagCompound).add("forgeCaps", (Object)this.forgeCaps).add("tagMatch", (Object)this.tagMatch).add("capMatch", (Object)this.capMatch).toString();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ComparisonMode {
        EXACT_MATCH(0){

            @Override
            public boolean match(CompoundTag nbt, @Nullable CompoundTag other) {
                return nbt.equals((Object)other);
            }
        }
        ,
        SUB_TAG_MATCH(1){

            @Override
            public boolean match(CompoundTag nbt, @Nullable CompoundTag other) {
                if (other == null) {
                    return false;
                }
                for (String key : nbt.m_128431_()) {
                    Tag val = nbt.m_128423_(key);
                    if (val == null) {
                        if (other.m_128423_(key) == null) continue;
                        return false;
                    }
                    if (!other.m_128425_(key, (int)val.m_7060_()) || other.m_128423_(key) == null) {
                        return false;
                    }
                    if (val.m_7060_() == 10 && !this.match((CompoundTag)val, other.m_128469_(key))) {
                        return false;
                    }
                    if (val.m_7060_() == 10 || val.m_7916_().equals(other.m_128423_(key).m_7916_())) continue;
                    return false;
                }
                return true;
            }
        };

        private static final Byte2ObjectMap<ComparisonMode> BY_ID;
        private final byte id;

        private ComparisonMode(int id) {
            this.id = (byte)id;
        }

        public byte getId() {
            return this.id;
        }

        public abstract boolean match(CompoundTag var1, @Nullable CompoundTag var2);

        public static ComparisonMode byId(byte id) {
            ComparisonMode mode = (ComparisonMode)((Object)BY_ID.get(id));
            return mode == null ? EXACT_MATCH : mode;
        }

        static {
            BY_ID = new Byte2ObjectOpenHashMap();
            Arrays.stream(ComparisonMode.values()).forEach(m -> BY_ID.put(m.getId(), (Object)m));
        }
    }

    public static final class Serializer
    extends ForgeRegistryEntry<IUniqueObjectSerializer>
    implements IUniqueObjectSerializer {
        @Override
        public CompoundTag serialize(IUniqueObject<?> obj, boolean persisted) {
            UniqueItem item = (UniqueItem)obj;
            CompoundTag res = new CompoundTag();
            if (item.tagCompound != null) {
                res.m_128365_("data", (Tag)item.tagCompound);
            }
            if (item.forgeCaps != null) {
                res.m_128365_("cap_data", (Tag)item.forgeCaps);
            }
            if (persisted) {
                res.m_128359_("id", item.getIndexObject().getRegistryName().toString());
            } else {
                res.m_128405_("id", RegistryUtils.getId(ForgeRegistries.ITEMS, item.item));
            }
            res.m_128344_("data_comp", item.tagMatch.getId());
            res.m_128344_("cap_comp", item.capMatch.getId());
            return res;
        }

        public IUniqueObject<Item> deserialize(CompoundTag res) {
            Preconditions.checkArgument((boolean)res.m_128441_("id"), (Object)"Cannot construct a UniqueItem without an Item!");
            CompoundTag nbt = res.m_128469_("data");
            ComparisonMode mode = ComparisonMode.byId(res.m_128445_("data_comp"));
            CompoundTag capNbt = res.m_128469_("cap_data");
            ComparisonMode capMode = ComparisonMode.byId(res.m_128445_("cap_comp"));
            Item item = res.m_128425_("id", 3) ? (Item)RegistryUtils.getById(ForgeRegistries.ITEMS, res.m_128451_("id")) : (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(res.m_128461_("id")));
            return new UniqueItem(item, nbt.m_128456_() ? null : nbt, mode, capNbt.m_128456_() ? null : capNbt, capMode);
        }

        @Override
        public JsonSerializer<IUniqueObject<?>> asJsonSerializer(boolean printName, boolean extended) {
            return (uobj, typeOfSrc, context) -> {
                JsonObject obj = new JsonObject();
                UniqueItem element = (UniqueItem)uobj;
                Item item = element.getIndexObject();
                if (printName) {
                    obj.addProperty("name", I18n.m_118938_((String)item.m_5671_(element.createStack()), (Object[])new Object[0]));
                }
                obj.add("id", context.serialize((Object)element.getIndexObject().getRegistryName()));
                if (extended) {
                    if (element.tagCompound != null && !element.tagCompound.m_128456_()) {
                        obj.addProperty("nbt", element.tagCompound.toString());
                        obj.add("nbt_match_type", context.serialize((Object)element.tagMatch));
                    }
                    if (element.forgeCaps != null && !element.forgeCaps.m_128456_()) {
                        obj.addProperty("cap_nbt", element.forgeCaps.toString());
                        obj.add("cap_nbt_match_type", context.serialize((Object)element.capMatch));
                    }
                }
                return obj;
            };
        }

        @Override
        public JsonDeserializer<IUniqueObject<?>> asJsonDeserializer() {
            return (json, typeOfT, context) -> {
                JsonObject object = json.getAsJsonObject();
                ResourceLocation registryName = (ResourceLocation)context.deserialize(object.get("id"), ResourceLocation.class);
                Item item = (Item)ForgeRegistries.ITEMS.getValue(registryName);
                if (item == null) {
                    return new UniqueItem(Items.f_41852_);
                }
                CompoundTag tagCompound = null;
                ComparisonMode tagMatch = ComparisonMode.EXACT_MATCH;
                if (object.has("nbt")) {
                    try {
                        tagCompound = TagParser.m_129359_((String)object.getAsJsonPrimitive("nbt").getAsString());
                        tagMatch = (ComparisonMode)((Object)((Object)context.deserialize(object.get("nbt_match_type"), ComparisonMode.class)));
                    }
                    catch (CommandSyntaxException e) {
                        e.printStackTrace();
                    }
                }
                CompoundTag forgeCaps = null;
                ComparisonMode capMatch = ComparisonMode.EXACT_MATCH;
                if (object.has("cap_nbt")) {
                    try {
                        forgeCaps = TagParser.m_129359_((String)object.getAsJsonPrimitive("cap_nbt").getAsString());
                        capMatch = (ComparisonMode)((Object)((Object)context.deserialize(object.get("cap_nbt_match_type"), ComparisonMode.class)));
                    }
                    catch (CommandSyntaxException e) {
                        e.printStackTrace();
                    }
                }
                return new UniqueItem(item, tagCompound, tagMatch, forgeCaps, capMatch);
            };
        }
    }
}

