/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.common.tainted.save;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.tainted.building.BlockData;
import com.direwolf20.buildinggadgets.common.tainted.building.Region;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.ITileDataSerializer;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.ITileEntityData;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.NBTTileEntityData;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.TileSupport;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.objects.IUniqueObject;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.objects.IUniqueObjectSerializer;
import com.direwolf20.buildinggadgets.common.tainted.registry.Registries;
import com.direwolf20.buildinggadgets.common.tainted.template.SerialisationSupport;
import com.direwolf20.buildinggadgets.common.util.compression.DataCompressor;
import com.direwolf20.buildinggadgets.common.util.compression.DataDecompressor;
import com.direwolf20.buildinggadgets.common.util.helpers.NBTHelper;
import com.direwolf20.buildinggadgets.common.util.tools.RegistryUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public final class Undo {
    private ResourceKey<Level> dim;
    private Map<BlockPos, BlockInfo> dataMap;
    private Region boundingBox;

    static Undo deserialize(CompoundTag nbt) {
        Preconditions.checkArgument((nbt.m_128425_("dim", 8) && nbt.m_128425_("items_serializer_list", 9) && nbt.m_128425_("block_list", 9) && nbt.m_128425_("data_list", 9) && nbt.m_128425_("data_serializer_list", 9) ? 1 : 0) != 0);
        DataDecompressor<ITileDataSerializer> serializerReverseObjectIncrementer = new DataDecompressor<ITileDataSerializer>((ListTag)nbt.m_128423_("data_serializer_list"), inbt -> {
            String s = inbt.m_7916_();
            ITileDataSerializer serializer = RegistryUtils.getFromString(Registries.TileEntityData.getTileDataSerializers(), s);
            if (serializer == null) {
                BuildingGadgets.LOG.warn("Found unknown serializer {}. Replacing with dummy!", (Object)s);
                serializer = TileSupport.dummyTileEntityData().getSerializer();
            }
            return serializer;
        }, value -> {
            BuildingGadgets.LOG.warn("Attempted to query unknown serializer {}. Replacing with dummy!", (Object)value);
            return TileSupport.dummyTileEntityData().getSerializer();
        });
        DataDecompressor<BlockData> dataReverseObjectIncrementer = new DataDecompressor<BlockData>((ListTag)nbt.m_128423_("data_list"), inbt -> BlockData.deserialize((CompoundTag)inbt, serializerReverseObjectIncrementer, true), value -> BlockData.AIR);
        DataDecompressor<IUniqueObjectSerializer> itemSerializerIncrementer = new DataDecompressor<IUniqueObjectSerializer>((ListTag)nbt.m_128423_("items_serializer_list"), inbt -> {
            String s = inbt.m_7916_();
            IUniqueObjectSerializer serializer = RegistryUtils.getFromString(Registries.getUniqueObjectSerializers(), s);
            if (serializer == null) {
                return SerialisationSupport.uniqueItemSerializer();
            }
            return serializer;
        }, value -> {
            BuildingGadgets.LOG.warn("Attempted to query unknown item-serializer {}. Replacing with default!", (Object)value);
            return SerialisationSupport.uniqueItemSerializer();
        });
        DataDecompressor<Multiset> itemSetReverseObjectIncrementer = new DataDecompressor<Multiset>((ListTag)nbt.m_128423_("items_list"), inbt -> NBTHelper.deserializeMultisetEntries((ListTag)inbt, HashMultiset.create(), entry -> Undo.readEntry(entry, itemSerializerIncrementer)), value -> HashMultiset.create());
        Map<BlockPos, BlockInfo> map = NBTHelper.deserializeMap((ListTag)nbt.m_128423_("block_list"), new HashMap(), inbt -> NbtUtils.m_129239_((CompoundTag)((CompoundTag)inbt)), inbt -> BlockInfo.deserialize((CompoundTag)inbt, dataReverseObjectIncrementer, itemSetReverseObjectIncrementer));
        ResourceKey dim = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(nbt.m_128461_("dim")));
        Region bounds = Region.deserializeFrom(nbt.m_128469_("bounding_box"));
        return new Undo((ResourceKey<Level>)dim, map, bounds);
    }

    private static Tuple<IUniqueObject<?>, Integer> readEntry(Tag inbt, IntFunction<IUniqueObjectSerializer> serializerIntFunction) {
        CompoundTag nbt = (CompoundTag)inbt;
        IUniqueObjectSerializer serializer = serializerIntFunction.apply(nbt.m_128451_("serializer"));
        int count = nbt.m_128451_("count");
        IUniqueObject<?> item = serializer.deserialize(nbt.m_128469_("item"));
        return new Tuple(item, (Object)count);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Undo(ResourceKey<Level> dim, Map<BlockPos, BlockInfo> dataMap, Region boundingBox) {
        this.dim = dim;
        this.dataMap = dataMap;
        this.boundingBox = boundingBox;
    }

    public Region getBoundingBox() {
        return this.boundingBox;
    }

    public Map<BlockPos, BlockInfo> getUndoData() {
        return Collections.unmodifiableMap(this.dataMap);
    }

    CompoundTag serialize() {
        DataCompressor<BlockData> dataObjectIncrementer = new DataCompressor<BlockData>();
        DataCompressor<IUniqueObjectSerializer> itemSerializerIncrementer = new DataCompressor<IUniqueObjectSerializer>();
        DataCompressor<Multiset> itemObjectIncrementer = new DataCompressor<Multiset>();
        DataCompressor<ITileDataSerializer> serializerObjectIncrementer = new DataCompressor<ITileDataSerializer>();
        CompoundTag res = new CompoundTag();
        ListTag infoList = NBTHelper.serializeMap(this.dataMap, NbtUtils::m_129224_, i -> i.serialize(dataObjectIncrementer, itemObjectIncrementer));
        ListTag dataList = dataObjectIncrementer.write(d -> d.serialize(serializerObjectIncrementer, true));
        ListTag itemSetList = itemObjectIncrementer.write(ms -> NBTHelper.writeIterable(ms.entrySet(), entry -> this.writeEntry((Multiset.Entry<IUniqueObject<?>>)entry, itemSerializerIncrementer)));
        ListTag dataSerializerList = serializerObjectIncrementer.write(ts -> StringTag.m_129297_((String)ts.getRegistryName().toString()));
        ListTag itemSerializerList = itemSerializerIncrementer.write(s -> StringTag.m_129297_((String)s.getRegistryName().toString()));
        res.m_128359_("dim", this.dim.getRegistryName().toString());
        res.m_128365_("block_list", (Tag)infoList);
        res.m_128365_("data_list", (Tag)dataList);
        res.m_128365_("data_serializer_list", (Tag)dataSerializerList);
        res.m_128365_("items_list", (Tag)itemSetList);
        res.m_128365_("items_serializer_list", (Tag)itemSerializerList);
        res.m_128365_("bounding_box", (Tag)this.boundingBox.serialize());
        return res;
    }

    private CompoundTag writeEntry(Multiset.Entry<IUniqueObject<?>> entry, ToIntFunction<IUniqueObjectSerializer> serializerObjectIncrementer) {
        CompoundTag res = new CompoundTag();
        res.m_128405_("serializer", serializerObjectIncrementer.applyAsInt(((IUniqueObject)entry.getElement()).getSerializer()));
        res.m_128365_("item", (Tag)((IUniqueObject)entry.getElement()).getSerializer().serialize((IUniqueObject)entry.getElement(), true));
        res.m_128405_("count", entry.getCount());
        return res;
    }

    public static final class Builder {
        private final ImmutableMap.Builder<BlockPos, BlockInfo> mapBuilder = ImmutableMap.builder();
        private Region.Builder regionBuilder = null;

        private Builder() {
        }

        public Builder record(BlockGetter reader, BlockPos pos, BlockData placeData, Multiset<IUniqueObject<?>> requiredItems, Multiset<IUniqueObject<?>> producedItems) {
            BlockState state = reader.m_8055_(pos);
            BlockEntity te = reader.m_7702_(pos);
            ITileEntityData data = te != null ? NBTTileEntityData.ofTile(te) : TileSupport.dummyTileEntityData();
            return this.record(pos, new BlockData(state, data), placeData, requiredItems, producedItems);
        }

        private Builder record(BlockPos pos, BlockData recordedData, BlockData placedData, Multiset<IUniqueObject<?>> requiredItems, Multiset<IUniqueObject<?>> producedItems) {
            this.mapBuilder.put((Object)pos, (Object)new BlockInfo(recordedData, placedData, requiredItems, producedItems));
            if (this.regionBuilder == null) {
                this.regionBuilder = Region.enclosingBuilder();
            }
            this.regionBuilder.enclose((Vec3i)pos);
            return this;
        }

        public Undo build(Level dim) {
            return new Undo((ResourceKey<Level>)dim.m_46472_(), (Map<BlockPos, BlockInfo>)this.mapBuilder.build(), this.regionBuilder != null ? this.regionBuilder.build() : Region.singleZero());
        }
    }

    public static final class BlockInfo {
        private final BlockData recordedData;
        private final BlockData placedData;
        private final Multiset<IUniqueObject<?>> usedItems;
        private final Multiset<IUniqueObject<?>> producedItems;

        private static BlockInfo deserialize(CompoundTag nbt, IntFunction<BlockData> dataSupplier, IntFunction<Multiset<IUniqueObject<?>>> itemSetSupplier) {
            BlockData data = dataSupplier.apply(nbt.m_128451_("recorded_data"));
            BlockData placedData = dataSupplier.apply(nbt.m_128451_("placed_data"));
            Multiset<IUniqueObject<?>> usedItems = itemSetSupplier.apply(nbt.m_128451_("used_items"));
            Multiset<IUniqueObject<?>> producedItems = itemSetSupplier.apply(nbt.m_128451_("produced_items"));
            return new BlockInfo(data, placedData, usedItems, producedItems);
        }

        private BlockInfo(BlockData recordedData, BlockData placedData, Multiset<IUniqueObject<?>> usedItems, Multiset<IUniqueObject<?>> producedItems) {
            this.recordedData = recordedData;
            this.placedData = placedData;
            this.usedItems = usedItems;
            this.producedItems = producedItems;
        }

        private CompoundTag serialize(ToIntFunction<BlockData> dataIdSupplier, ToIntFunction<Multiset<IUniqueObject<?>>> itemIdSupplier) {
            CompoundTag res = new CompoundTag();
            res.m_128405_("recorded_data", dataIdSupplier.applyAsInt(this.recordedData));
            res.m_128405_("placed_data", dataIdSupplier.applyAsInt(this.placedData));
            res.m_128405_("used_items", itemIdSupplier.applyAsInt(this.usedItems));
            res.m_128405_("produced_items", itemIdSupplier.applyAsInt(this.producedItems));
            return res;
        }

        public BlockData getRecordedData() {
            return this.recordedData;
        }

        public BlockData getPlacedData() {
            return this.placedData;
        }

        public Multiset<IUniqueObject<?>> getUsedItems() {
            return Multisets.unmodifiableMultiset(this.usedItems);
        }

        public Multiset<IUniqueObject<?>> getProducedItems() {
            return Multisets.unmodifiableMultiset(this.producedItems);
        }
    }
}

