/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.chunkymcchunkface.blocks.entity;

import com.mojang.datafixers.util.Pair;
import com.mrbysco.chunkymcchunkface.ChunkyMcChunkFace;
import com.mrbysco.chunkymcchunkface.blocks.ChunkLoaderBlock;
import com.mrbysco.chunkymcchunkface.blocks.entity.ChunkLoaderBlockEntity;
import com.mrbysco.chunkymcchunkface.registry.ChunkyRegistry;
import com.mrbysco.chunkymcchunkface.util.ChunkyHelper;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.world.ForgeChunkManager;

public class ChunkValidationCallback
implements ForgeChunkManager.LoadingValidationCallback {
    public static final ChunkValidationCallback INSTANCE = new ChunkValidationCallback();

    private ChunkValidationCallback() {
    }

    public void validateTickets(ServerLevel serverLevel, ForgeChunkManager.TicketHelper ticketHelper) {
        ResourceLocation dimensionLocation = serverLevel.m_46472_().m_135782_();
        for (Map.Entry entry : ticketHelper.getBlockTickets().entrySet()) {
            BlockPos pos = (BlockPos)entry.getKey();
            LongSet forcedChunks = (LongSet)((Pair)entry.getValue()).getFirst();
            LongSet tickingForcedChunks = (LongSet)((Pair)entry.getValue()).getSecond();
            this.validateTickets(serverLevel, dimensionLocation, pos, ticketHelper, forcedChunks, false);
            this.validateTickets(serverLevel, dimensionLocation, pos, ticketHelper, tickingForcedChunks, true);
        }
    }

    private void validateTickets(ServerLevel serverLevel, ResourceLocation dimensionLocation, BlockPos pos, ForgeChunkManager.TicketHelper ticketHelper, LongSet forcedChunks, boolean ticking) {
        BlockEntity blockEntity;
        int ticketCount = forcedChunks.size();
        if (ticketCount > 0 && (blockEntity = serverLevel.m_7702_(pos)) instanceof ChunkLoaderBlockEntity) {
            ChunkLoaderBlockEntity blockEntity2 = (ChunkLoaderBlockEntity)blockEntity;
            if (blockEntity2.isEnabled()) {
                LongSet chunks;
                if (!forcedChunks.equals(blockEntity2.loadedChunks)) {
                    ChunkyMcChunkFace.LOGGER.debug("Mismatched chunkSet for chunk loader at position: {} in {}. Correcting.", (Object)pos, (Object)dimensionLocation);
                    blockEntity2.loadedChunks.clear();
                    blockEntity2.loadedChunks.addAll((LongCollection)forcedChunks);
                    blockEntity2.m_6596_();
                }
                if ((chunks = ChunkyHelper.generateChunkPosList(new ChunkPos(pos).m_45588_(), blockEntity2.getTier())).isEmpty()) {
                    ChunkyMcChunkFace.LOGGER.warn("Removing {} chunk tickets as they are no longer valid as this loader does not expect to have any tickets even though it is can operate. Pos: {} World: {}", new Object[]{ticketCount, pos, dimensionLocation});
                    this.releaseAllTickets(blockEntity2, pos, ticketHelper);
                } else {
                    int removed = 0;
                    int added = 0;
                    LongIterator chunkIt = blockEntity2.loadedChunks.iterator();
                    while (chunkIt.hasNext()) {
                        long chunkPos = chunkIt.nextLong();
                        if (chunks.contains(chunkPos) && ticking == blockEntity2.isEnabled()) continue;
                        ticketHelper.removeTicket(pos, chunkPos, ticking);
                        chunkIt.remove();
                        ++removed;
                    }
                    LongIterator longIterator = chunks.iterator();
                    while (longIterator.hasNext()) {
                        long chunkPos = (Long)longIterator.next();
                        if (!blockEntity2.loadedChunks.add(chunkPos) && ticking == blockEntity2.isEnabled()) continue;
                        ForgeChunkManager.forceChunk((ServerLevel)serverLevel, (String)"chunkymcchunkface", (BlockPos)pos, (int)((int)chunkPos), (int)((int)(chunkPos >> 32)), (boolean)true, (boolean)true);
                        ++added;
                    }
                    if (removed == 0 && added == 0) {
                        ChunkyMcChunkFace.LOGGER.debug("Chunk tickets for position: {} in {}, successfully validated.", (Object)pos, (Object)dimensionLocation);
                    } else {
                        blockEntity2.m_6596_();
                        ChunkyMcChunkFace.LOGGER.info("Removed {} no longer valid chunk tickets, and added {} newly valid chunk tickets. Pos: {} World: {}", new Object[]{removed, added, pos, dimensionLocation});
                    }
                }
            } else {
                ChunkyMcChunkFace.LOGGER.info("Removing {} chunk tickets as they are no longer valid. Pos: {} World: {}", new Object[]{ticketCount, pos, dimensionLocation});
                this.releaseAllTickets(blockEntity2, pos, ticketHelper);
            }
        }
    }

    private void releaseAllTickets(ChunkLoaderBlockEntity blockEntity, BlockPos pos, ForgeChunkManager.TicketHelper ticketHelper) {
        ticketHelper.removeAllTickets(pos);
        blockEntity.loadedChunks.clear();
        BlockState state = blockEntity.m_58900_();
        if (state.m_60713_((Block)ChunkyRegistry.CHUNK_LOADER.get())) {
            blockEntity.m_58904_().m_46597_(pos, (BlockState)state.m_61124_((Property)ChunkLoaderBlock.ENABLED, (Comparable)Boolean.valueOf(false)));
        }
        blockEntity.m_6596_();
    }
}

