/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.chunkymcchunkface.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mrbysco.chunkymcchunkface.blocks.entity.ChunkLoaderBlockEntity;
import com.mrbysco.chunkymcchunkface.client.ChunkyRenderTypes;
import com.mrbysco.chunkymcchunkface.registry.ChunkyRegistry;
import com.mrbysco.chunkymcchunkface.util.ChunkyHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ChunkLoaderBER
implements BlockEntityRenderer<ChunkLoaderBlockEntity> {
    public static boolean renderChunkRadius = false;
    public final Map<Long, Integer> rangeMap = new HashMap<Long, Integer>();

    public ChunkLoaderBER(BlockEntityRendererProvider.Context context) {
    }

    public void render(ChunkLoaderBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLightIn, int combinedOverlayIn) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        if (player.m_21205_().m_150930_((Item)ChunkyRegistry.CHUNK_LOADER_ITEM.get())) {
            this.renderOutline(blockEntity, poseStack, bufferSource);
        }
        if (mc.f_91073_ != null && renderChunkRadius) {
            List<ChunkPos> list;
            BlockPos loaderPos = blockEntity.m_58899_();
            long posLong = loaderPos.m_121878_();
            long centerChunk = new ChunkPos(loaderPos).m_45588_();
            if (!this.rangeMap.containsKey(posLong)) {
                this.rangeMap.put(posLong, blockEntity.getRange());
            }
            if ((list = ChunkyHelper.generateChunkPosList(centerChunk, blockEntity.getRange()).stream().map(ChunkPos::new).toList()).isEmpty()) {
                return;
            }
            ArrayList<AABB> boxes = new ArrayList<AABB>();
            for (ChunkPos chunkPos : list) {
                AABB box = AABB.m_82321_((BoundingBox)new BoundingBox(chunkPos.m_45604_(), mc.f_91073_.m_141937_(), chunkPos.m_45605_(), chunkPos.m_45608_(), mc.f_91073_.m_151558_(), chunkPos.m_45609_()));
                box = box.m_82400_((double)0.01f);
                boxes.add(box);
            }
            AABB box = (AABB)boxes.get(0);
            for (AABB aabb : boxes) {
                box = box.m_82367_(aabb);
            }
            box = box.m_82400_((double)0.01f);
            VertexConsumer vertexConsumer = bufferSource.m_6299_(ChunkyRenderTypes.translucentRenderType());
            poseStack.m_85836_();
            poseStack.m_85837_((double)(-loaderPos.m_123341_()), (double)(-loaderPos.m_123342_()), (double)(-loaderPos.m_123343_()));
            this.renderAABB(vertexConsumer, poseStack, box);
            poseStack.m_85849_();
            if (bufferSource instanceof MultiBufferSource.BufferSource) {
                ((MultiBufferSource.BufferSource)bufferSource).m_109911_();
            }
        }
    }

    public void renderAABB(VertexConsumer vertexConsumer, PoseStack poseStack, AABB box) {
        float red = 1.0f;
        float green = 0.65f;
        float blue = 0.0f;
        float alpha = 0.25f;
        float alphaSide = 0.15f;
        poseStack.m_85836_();
        PoseStack.Pose matrixLast = poseStack.m_85850_();
        Matrix4f pose = matrixLast.m_85861_();
        Matrix3f normal = matrixLast.m_85864_();
        vertexConsumer.m_85982_(pose, (float)box.f_82288_, (float)box.f_82289_, (float)box.f_82290_).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        vertexConsumer.m_85982_(pose, (float)box.f_82291_, (float)box.f_82289_, (float)box.f_82290_).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        vertexConsumer.m_85982_(pose, (float)box.f_82291_, (float)box.f_82289_, (float)box.f_82293_).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        vertexConsumer.m_85982_(pose, (float)box.f_82288_, (float)box.f_82289_, (float)box.f_82293_).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        vertexConsumer.m_85982_(pose, (float)box.f_82288_, (float)box.f_82292_, (float)box.f_82290_).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        vertexConsumer.m_85982_(pose, (float)box.f_82288_, (float)box.f_82292_, (float)box.f_82293_).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        vertexConsumer.m_85982_(pose, (float)box.f_82291_, (float)box.f_82292_, (float)box.f_82293_).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        vertexConsumer.m_85982_(pose, (float)box.f_82291_, (float)box.f_82292_, (float)box.f_82290_).m_85977_(normal, 0.0f, -1.0f, 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        vertexConsumer.m_85982_(pose, (float)box.f_82288_, (float)box.f_82289_, (float)box.f_82290_).m_85977_(normal, 0.0f, 0.0f, 1.0f).m_85950_(red, green, blue, alphaSide).m_5752_();
        vertexConsumer.m_85982_(pose, (float)box.f_82291_, (float)box.f_82289_, (float)box.f_82290_).m_85977_(normal, 0.0f, 0.0f, 1.0f).m_85950_(red, green, blue, alphaSide).m_5752_();
        vertexConsumer.m_85982_(pose, (float)box.f_82291_, (float)box.f_82292_, (float)box.f_82290_).m_85977_(normal, 0.0f, 0.0f, 1.0f).m_85950_(red, green, blue, alphaSide).m_5752_();
        vertexConsumer.m_85982_(pose, (float)box.f_82288_, (float)box.f_82292_, (float)box.f_82290_).m_85977_(normal, 0.0f, 0.0f, 1.0f).m_85950_(red, green, blue, alphaSide).m_5752_();
        vertexConsumer.m_85982_(pose, (float)box.f_82288_, (float)box.f_82289_, (float)box.f_82293_).m_85977_(normal, 0.0f, 0.0f, -1.0f).m_85950_(red, green, blue, alphaSide).m_5752_();
        vertexConsumer.m_85982_(pose, (float)box.f_82288_, (float)box.f_82292_, (float)box.f_82293_).m_85977_(normal, 0.0f, 0.0f, -1.0f).m_85950_(red, green, blue, alphaSide).m_5752_();
        vertexConsumer.m_85982_(pose, (float)box.f_82291_, (float)box.f_82292_, (float)box.f_82293_).m_85977_(normal, 0.0f, 0.0f, -1.0f).m_85950_(red, green, blue, alphaSide).m_5752_();
        vertexConsumer.m_85982_(pose, (float)box.f_82291_, (float)box.f_82289_, (float)box.f_82293_).m_85977_(normal, 0.0f, 0.0f, -1.0f).m_85950_(red, green, blue, alphaSide).m_5752_();
        vertexConsumer.m_85982_(pose, (float)box.f_82288_, (float)box.f_82289_, (float)box.f_82290_).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_85950_(red, green, blue, alphaSide).m_5752_();
        vertexConsumer.m_85982_(pose, (float)box.f_82288_, (float)box.f_82289_, (float)box.f_82293_).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_85950_(red, green, blue, alphaSide).m_5752_();
        vertexConsumer.m_85982_(pose, (float)box.f_82288_, (float)box.f_82292_, (float)box.f_82293_).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_85950_(red, green, blue, alphaSide).m_5752_();
        vertexConsumer.m_85982_(pose, (float)box.f_82288_, (float)box.f_82292_, (float)box.f_82290_).m_85977_(normal, 1.0f, 0.0f, 0.0f).m_85950_(red, green, blue, alphaSide).m_5752_();
        vertexConsumer.m_85982_(pose, (float)box.f_82291_, (float)box.f_82289_, (float)box.f_82290_).m_85977_(normal, -1.0f, 0.0f, 0.0f).m_85950_(red, green, blue, alphaSide).m_5752_();
        vertexConsumer.m_85982_(pose, (float)box.f_82291_, (float)box.f_82292_, (float)box.f_82290_).m_85977_(normal, -1.0f, 0.0f, 0.0f).m_85950_(red, green, blue, alphaSide).m_5752_();
        vertexConsumer.m_85982_(pose, (float)box.f_82291_, (float)box.f_82292_, (float)box.f_82293_).m_85977_(normal, -1.0f, 0.0f, 0.0f).m_85950_(red, green, blue, alphaSide).m_5752_();
        vertexConsumer.m_85982_(pose, (float)box.f_82291_, (float)box.f_82289_, (float)box.f_82293_).m_85977_(normal, -1.0f, 0.0f, 0.0f).m_85950_(red, green, blue, alphaSide).m_5752_();
        poseStack.m_85849_();
    }

    private void renderOutline(ChunkLoaderBlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource) {
        RenderType renderType = ChunkyRenderTypes.lineRenderType(8.0f);
        BlockPos loaderPos = blockEntity.m_58899_();
        VertexConsumer builder = bufferSource.m_6299_(renderType);
        AABB box = AABB.m_82321_((BoundingBox)new BoundingBox(loaderPos));
        box = box.m_82400_((double)0.01f);
        poseStack.m_85836_();
        poseStack.m_85837_((double)(-loaderPos.m_123341_()), (double)(-loaderPos.m_123342_()), (double)(-loaderPos.m_123343_()));
        float[] onColor = new float[]{1.0f, 0.84313726f, 0.0f, 1.0f};
        float[] offColor = new float[]{0.5f, 0.0f, 0.125f, 1.0f};
        float[] colorToUse = blockEntity.isEnabled() ? onColor : offColor;
        LevelRenderer.m_109646_((PoseStack)poseStack, (VertexConsumer)builder, (AABB)box, (float)colorToUse[0], (float)colorToUse[1], (float)colorToUse[2], (float)colorToUse[3]);
        if (bufferSource instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource bufferSource1 = (MultiBufferSource.BufferSource)bufferSource;
            bufferSource1.m_109912_(renderType);
        }
        poseStack.m_85849_();
    }

    public boolean shouldRender(ChunkLoaderBlockEntity blockEntity, Vec3 pos) {
        return Vec3.m_82512_((Vec3i)blockEntity.m_58899_()).m_82542_(1.0, 0.0, 1.0).m_82509_((Position)pos.m_82542_(1.0, 0.0, 1.0), (double)this.m_142163_());
    }

    public boolean shouldRenderOffScreen(ChunkLoaderBlockEntity blockEntity) {
        return true;
    }

    public int m_142163_() {
        return 128;
    }
}

