/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.chunkymcchunkface.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mrbysco.chunkymcchunkface.blocks.entity.ChunkLoaderBlockEntity;
import com.mrbysco.chunkymcchunkface.data.ChunkData;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ChunkyCommands {
    @SubscribeEvent
    public void onRegisterCommandsEvent(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        LiteralArgumentBuilder root = Commands.m_82127_((String)"chunkymcchunkface");
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)root.requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"list").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(ctx -> this.generateList((CommandContext<CommandSourceStack>)ctx, false))).then(Commands.m_82127_((String)"enabled").executes(ctx -> this.generateList((CommandContext<CommandSourceStack>)ctx, true)))))).then(Commands.m_82127_((String)"disable").then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).then(Commands.m_82129_((String)"position", (ArgumentType)Vec3Argument.m_120841_()).suggests((context, builder) -> {
            ServerLevel dimensionLevel = DimensionArgument.m_88808_((CommandContext)context, (String)"dimension");
            return SharedSuggestionProvider.m_82970_(ChunkyCommands.getActivePositions(dimensionLevel), (SuggestionsBuilder)builder);
        }).executes(ChunkyCommands::disableChunkLoader))))).then(Commands.m_82127_((String)"disable_all").then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(ChunkyCommands::disableAllChunkLoaders)));
        dispatcher.register(root);
    }

    protected static List<String> getActivePositions(ServerLevel dimensionLevel) {
        ResourceLocation dimension = dimensionLevel.m_46472_().m_135782_();
        ChunkData data = ChunkData.get((Level)dimensionLevel);
        List<BlockPos> positions = data.getActivePositions(dimensionLevel, data.generateList(dimension));
        return positions.stream().map(pos -> pos.m_123341_() + " " + pos.m_123342_() + " " + pos.m_123343_()).toList();
    }

    private int generateList(CommandContext<CommandSourceStack> ctx, boolean enabledOnly) throws CommandSyntaxException {
        ServerLevel dimensionLevel = DimensionArgument.m_88808_(ctx, (String)"dimension");
        ResourceLocation dimension = dimensionLevel.m_46472_().m_135782_();
        ChunkData data = ChunkData.get((Level)dimensionLevel);
        List<BlockPos> positions = data.generateList(dimension);
        if (enabledOnly) {
            positions = data.getActivePositions(dimensionLevel, positions);
        }
        if (positions.isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("chunkymcchunkface.command.list.empty", new Object[]{new TextComponent(dimension.toString()).m_130940_(ChatFormatting.RED)}), true);
        } else {
            TextComponent formattedComponent = new TextComponent("\n");
            MutableComponent component = new TextComponent(", ").m_130940_(ChatFormatting.WHITE);
            for (int i = 0; i < positions.size(); ++i) {
                BlockPos pos = positions.get(i);
                MutableComponent position = ComponentUtils.m_130748_((Component)new TextComponent(pos.m_123344_())).m_130938_(style -> style.m_131140_(ChatFormatting.GOLD).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @s " + pos.m_123341_() + " " + pos.m_123342_() + " " + pos.m_123343_())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TranslatableComponent("chat.coordinates.tooltip"))));
                formattedComponent.m_7220_((Component)position);
                if (i >= positions.size() - 1) continue;
                formattedComponent.m_7220_((Component)component);
            }
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("chunkymcchunkface.command.list", new Object[]{new TextComponent(dimension.toString()).m_130940_(ChatFormatting.GOLD)}).m_7220_((Component)formattedComponent), true);
        }
        return 0;
    }

    private static int disableChunkLoader(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Vec3 pos;
        ServerLevel dimensionLevel = DimensionArgument.m_88808_(ctx, (String)"dimension");
        BlockEntity blockEntity = dimensionLevel.m_7702_(new BlockPos(pos = Vec3Argument.m_120844_(ctx, (String)"position")));
        if (blockEntity instanceof ChunkLoaderBlockEntity) {
            ChunkLoaderBlockEntity loader = (ChunkLoaderBlockEntity)blockEntity;
            loader.disableChunkLoaderState();
            loader.disableChunkLoader();
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("chunkymcchunkface.command.disable", new Object[]{pos.f_82479_, pos.f_82480_, pos.f_82481_}), true);
        } else {
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("chunkymcchunkface.command.disable.error", new Object[]{pos.f_82479_, pos.f_82480_, pos.f_82481_}), true);
        }
        return 0;
    }

    private static int disableAllChunkLoaders(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerLevel dimensionLevel = DimensionArgument.m_88808_(ctx, (String)"dimension");
        ResourceLocation dimension = dimensionLevel.m_46472_().m_135782_();
        ChunkData data = ChunkData.get((Level)dimensionLevel);
        List<BlockPos> positions = data.getActivePositions(dimensionLevel, data.generateList(dimension));
        MutableComponent dimensionComponent = new TextComponent(dimension.toString()).m_130940_(ChatFormatting.GOLD);
        if (positions.isEmpty()) {
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("chunkymcchunkface.command.disableall.empty", new Object[]{dimensionComponent}), true);
        } else {
            for (BlockPos pos : positions) {
                BlockEntity blockEntity = dimensionLevel.m_7702_(new BlockPos((Vec3i)pos));
                if (!(blockEntity instanceof ChunkLoaderBlockEntity)) continue;
                ChunkLoaderBlockEntity loader = (ChunkLoaderBlockEntity)blockEntity;
                loader.disableChunkLoaderState();
                loader.disableChunkLoader();
            }
            ((CommandSourceStack)ctx.getSource()).m_81354_((Component)new TranslatableComponent("chunkymcchunkface.command.disableall", new Object[]{dimensionComponent}), true);
        }
        return 0;
    }
}

