/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.chunkymcchunkface.data;

import com.mrbysco.chunkymcchunkface.blocks.ChunkLoaderBlock;
import com.mrbysco.chunkymcchunkface.registry.ChunkyRegistry;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class ChunkData
extends SavedData {
    private static final String DATA_NAME = "chunkymcchunkface_data";
    public final Map<ResourceLocation, LongSet> chunkloaderMap;
    public final Map<UUID, Long> playerTimeMap;

    public ChunkData(Map<ResourceLocation, LongSet> dimensionLoaderMap, Map<UUID, Long> playerTimeMap) {
        this.chunkloaderMap = dimensionLoaderMap;
        this.playerTimeMap = playerTimeMap;
    }

    public ChunkData() {
        this(new HashMap<ResourceLocation, LongSet>(), new HashMap<UUID, Long>());
    }

    public void addChunkLoaderPosition(Level level, BlockPos pos) {
        ResourceLocation dimensionLocation = level.m_46472_().m_135782_();
        LongSet loaderMap = this.chunkloaderMap.getOrDefault(dimensionLocation, (LongSet)new LongOpenHashSet());
        loaderMap.add(pos.m_121878_());
        this.chunkloaderMap.put(dimensionLocation, loaderMap);
        this.m_77762_();
    }

    public void removeChunkLoaderPosition(Level level, BlockPos pos) {
        ResourceLocation dimensionLocation = level.m_46472_().m_135782_();
        LongSet loaderMap = this.chunkloaderMap.getOrDefault(dimensionLocation, (LongSet)new LongOpenHashSet());
        loaderMap.remove(pos.m_121878_());
        this.chunkloaderMap.put(dimensionLocation, loaderMap);
        this.m_77762_();
    }

    public List<ChunkPos> getActiveChunkLoaderChunks(ServerLevel level) {
        ArrayList<ChunkPos> chunkPosList = new ArrayList<ChunkPos>();
        LongSet loaderPositions = this.chunkloaderMap.getOrDefault(level.m_46472_().m_135782_(), (LongSet)new LongOpenHashSet());
        LongIterator longIterator = loaderPositions.iterator();
        while (longIterator.hasNext()) {
            BlockState state;
            long posLong = (Long)longIterator.next();
            BlockPos pos = BlockPos.m_122022_((long)posLong);
            if (!level.isAreaLoaded(pos, 1) || !(state = level.m_8055_(pos)).m_60713_((Block)ChunkyRegistry.CHUNK_LOADER.get()) || !((Boolean)state.m_61143_((Property)ChunkLoaderBlock.ENABLED)).booleanValue()) continue;
            chunkPosList.add(new ChunkPos(pos));
        }
        return chunkPosList;
    }

    public List<BlockPos> generateList(ResourceLocation dimension) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        LongSet chunkLoaderList = this.chunkloaderMap.getOrDefault(dimension, (LongSet)new LongOpenHashSet());
        if (!chunkLoaderList.isEmpty()) {
            chunkLoaderList.forEach(posLong -> positions.add(BlockPos.m_122022_((long)posLong)));
        }
        return positions;
    }

    public List<BlockPos> getActivePositions(ServerLevel level, List<BlockPos> positions) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>(positions);
        posList.removeIf(pos -> {
            if (level.isAreaLoaded(pos, 1)) {
                BlockState state = level.m_8055_(pos);
                return !state.m_60713_((Block)ChunkyRegistry.CHUNK_LOADER.get()) || (Boolean)state.m_61143_((Property)ChunkLoaderBlock.ENABLED) == false;
            }
            return true;
        });
        return posList;
    }

    public long getLastSeen(UUID uuid) {
        return this.playerTimeMap.getOrDefault(uuid, 0L);
    }

    public void addPlayer(UUID uuid, long gameTime) {
        this.playerTimeMap.put(uuid, gameTime);
        this.m_77762_();
    }

    public void removePlayer(UUID uuid) {
        this.playerTimeMap.remove(uuid);
        this.m_77762_();
    }

    public static ChunkData load(CompoundTag tag) {
        ListTag loaderMapTag = tag.m_128437_("ChunkLoaderMap", 10);
        HashMap<ResourceLocation, LongSet> loaderMap = new HashMap<ResourceLocation, LongSet>();
        for (int i = 0; i < loaderMapTag.size(); ++i) {
            CompoundTag listTag = loaderMapTag.m_128728_(i);
            String dimension = listTag.m_128461_("Dimension");
            ResourceLocation dimensionLocation = ResourceLocation.m_135820_((String)dimension);
            LongOpenHashSet chunkLoaderSet = new LongOpenHashSet();
            for (long chunk : listTag.m_128467_("BlockPositions")) {
                chunkLoaderSet.add(chunk);
            }
            loaderMap.put(dimensionLocation, (LongSet)chunkLoaderSet);
        }
        ListTag playerTimeTag = tag.m_128437_("PlayerTimeMap", 10);
        HashMap<UUID, Long> playerTimeMap = new HashMap<UUID, Long>();
        for (int i = 0; i < playerTimeTag.size(); ++i) {
            CompoundTag listTag = playerTimeTag.m_128728_(i);
            UUID uuid = listTag.m_128342_("UUID");
            long time = listTag.m_128454_("Time");
            playerTimeMap.put(uuid, time);
        }
        return new ChunkData(loaderMap, playerTimeMap);
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag loaderMapTag = new ListTag();
        for (Map.Entry<ResourceLocation, LongSet> entry : this.chunkloaderMap.entrySet()) {
            CompoundTag loaderTag = new CompoundTag();
            loaderTag.m_128359_("Dimension", entry.getKey().toString());
            loaderTag.m_128388_("BlockPositions", entry.getValue().toLongArray());
            loaderMapTag.add((Object)loaderTag);
        }
        tag.m_128365_("ChunkLoaderMap", (Tag)loaderMapTag);
        ListTag playerTimeTag = new ListTag();
        for (Map.Entry<UUID, Long> entry : this.playerTimeMap.entrySet()) {
            CompoundTag playerTag = new CompoundTag();
            playerTag.m_128362_("UUID", entry.getKey());
            playerTag.m_128356_("Time", entry.getValue().longValue());
            playerTimeTag.add((Object)playerTag);
        }
        tag.m_128365_("PlayerTimeMap", (Tag)playerTimeTag);
        return tag;
    }

    public static ChunkData get(Level level) {
        if (!(level instanceof ServerLevel)) {
            throw new RuntimeException("Attempted to get the data from a client level. This is wrong.");
        }
        ServerLevel overworld = level.m_142572_().m_129783_();
        DimensionDataStorage storage = overworld.m_8895_();
        return (ChunkData)storage.m_164861_(ChunkData::load, ChunkData::new, DATA_NAME);
    }
}

