/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.chunkymcchunkface.util;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraftforge.common.world.ForgeChunkManager;

public class ChunkyHelper {
    public static LongSet generateChunkPosList(long center, int range) {
        LongOpenHashSet chunkPosList = new LongOpenHashSet();
        int centerX = (int)center;
        int centerZ = (int)(center >> 32);
        for (int x = centerX - range; x <= centerX + range; ++x) {
            for (int z = centerZ - range; z <= centerZ + range; ++z) {
                ChunkPos chunkPos = new ChunkPos(x, z);
                chunkPosList.add(chunkPos.m_45588_());
            }
        }
        return chunkPosList;
    }

    public static void registerChunkTicket(ServerLevel serverLevel, BlockPos ownerPos, long chunkPos) {
        ForgeChunkManager.forceChunk((ServerLevel)serverLevel, (String)"chunkymcchunkface", (BlockPos)ownerPos, (int)((int)chunkPos), (int)((int)(chunkPos >> 32)), (boolean)true, (boolean)true);
    }

    public static void releaseChunkTicket(ServerLevel serverLevel, BlockPos ownerPos, long chunkPos) {
        ForgeChunkManager.forceChunk((ServerLevel)serverLevel, (String)"chunkymcchunkface", (BlockPos)ownerPos, (int)((int)chunkPos), (int)((int)(chunkPos >> 32)), (boolean)false, (boolean)true);
    }

    public static String formatTicks(int ticks) {
        int totalSeconds = ticks / 20;
        int hours = totalSeconds / 3600;
        int minutes = totalSeconds % 3600 / 60;
        int seconds = totalSeconds % 60;
        return String.format("%02d:%02d:%02d", hours, minutes, seconds);
    }
}

