/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vaultintegrations.block.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.refinedmods.refinedstorage.blockentity.ControllerBlockEntity;
import iskallia.vaultintegrations.altar.FloatingItem;
import iskallia.vaultintegrations.block.entity.AltarConduitBlockEntity;
import iskallia.vaultintegrations.init.VIConfigs;
import iskallia.vaultintegrations.util.MyRenderType;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Vec3i;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class AltarConduitRenderer
implements BlockEntityRenderer<AltarConduitBlockEntity> {
    public AltarConduitRenderer(BlockEntityRendererProvider.Context ignored) {
    }

    public boolean shouldRenderOffScreen(@NotNull AltarConduitBlockEntity altarConduit) {
        return true;
    }

    public boolean shouldRender(@NotNull AltarConduitBlockEntity altarConduit, @NotNull Vec3 cameraPos) {
        return true;
    }

    public void render(@NotNull AltarConduitBlockEntity altarConduit, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int overlay) {
        Optional<appeng.blockentity.networking.ControllerBlockEntity> aeController;
        Vec3 controllerLocalPos;
        Vec3 controllerPos;
        ProfilerFiller profiler = Minecraft.m_91087_().m_91307_();
        profiler.m_6180_("AltarConduitRenderer");
        Vec3 conduitPos = Vec3.m_82512_((Vec3i)altarConduit.m_58899_().m_122032_());
        Optional<ControllerBlockEntity> rsController = altarConduit.getRSController();
        if (rsController.isPresent()) {
            controllerPos = Vec3.m_82512_((Vec3i)rsController.get().m_58899_().m_122032_());
            controllerLocalPos = new Vec3(controllerPos.f_82479_ - conduitPos.f_82479_, controllerPos.f_82480_ - conduitPos.f_82480_, controllerPos.f_82481_ - conduitPos.f_82481_);
            if (altarConduit.inDebugMode()) {
                this.renderDebugLine(poseStack, controllerLocalPos);
            }
        }
        if ((aeController = altarConduit.getAEController()).isPresent()) {
            controllerPos = Vec3.m_82512_((Vec3i)aeController.get().m_58899_().m_122032_());
            controllerLocalPos = new Vec3(controllerPos.f_82479_ - conduitPos.f_82479_, controllerPos.f_82480_ - conduitPos.f_82480_, controllerPos.f_82481_ - conduitPos.f_82481_);
            if (altarConduit.inDebugMode()) {
                this.renderDebugLine(poseStack, controllerLocalPos);
            }
        }
        this.renderFloatingItems(altarConduit, partialTicks, poseStack, bufferSource, packedLight, overlay, conduitPos);
        profiler.m_7238_();
    }

    private void renderDebugLine(@NotNull PoseStack poseStack, Vec3 controllerLocalPos) {
        Vec3 origin = new Vec3(0.5, 0.5, 0.5);
        double maxDistance = VIConfigs.ALTAR_CONDUIT.getMaxDistance();
        boolean outOfRange = origin.m_82557_(controllerLocalPos) > maxDistance * maxDistance;
        MultiBufferSource.BufferSource source = Minecraft.m_91087_().m_91269_().m_110104_();
        VertexConsumer buffer = source.m_6299_(MyRenderType.OVERLAY_LINES);
        Matrix4f pose = poseStack.m_85850_().m_85861_();
        buffer.m_85982_(pose, 0.5f, 0.5f, 0.5f).m_85950_(outOfRange ? 1.0f : 0.0f, outOfRange ? 0.0f : 1.0f, 0.0f, 1.0f).m_5752_();
        buffer.m_85982_(pose, (float)controllerLocalPos.f_82479_ + 0.5f, (float)controllerLocalPos.f_82480_ + 0.5f, (float)controllerLocalPos.f_82481_ + 0.5f).m_85950_(outOfRange ? 1.0f : 0.0f, outOfRange ? 0.0f : 1.0f, 0.0f, 1.0f).m_5752_();
        source.m_109912_(MyRenderType.OVERLAY_LINES);
    }

    private void renderFloatingItems(@NotNull AltarConduitBlockEntity altarConduit, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int overlay, Vec3 conduitPos) {
        if (altarConduit.getFloatingItemsMap().isEmpty()) {
            return;
        }
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        List allFloatingItems = altarConduit.getFloatingItemsMap().values().stream().flatMap(Collection::stream).toList();
        for (FloatingItem floatingItem : allFloatingItems) {
            Vec3 prevPos = floatingItem.getPrevPos();
            Vec3 itemPos = new Vec3(prevPos.f_82479_ + (floatingItem.getItemPos().f_82479_ - prevPos.f_82479_) * (double)partialTicks, prevPos.f_82480_ + (floatingItem.getItemPos().f_82480_ - prevPos.f_82480_) * (double)partialTicks, prevPos.f_82481_ + (floatingItem.getItemPos().f_82481_ - prevPos.f_82481_) * (double)partialTicks);
            ItemStack stack = ((Item)ForgeRegistries.ITEMS.getValue(floatingItem.getItemId())).m_7968_();
            BakedModel ibakedmodel = itemRenderer.m_174264_(stack, null, null, 0);
            this.renderFloatingItem(poseStack, bufferSource, packedLight, overlay, conduitPos, itemRenderer, itemPos, stack, ibakedmodel);
            if (floatingItem.getAmount() <= 1) continue;
            poseStack.m_85836_();
            poseStack.m_85837_(-conduitPos.f_82479_ + 0.5, -conduitPos.f_82480_ + 0.5, -conduitPos.f_82481_ + 0.5);
            poseStack.m_85837_(itemPos.f_82479_ + 0.05, itemPos.f_82480_ - 0.05, itemPos.f_82481_ + 0.05);
            Vec3 direction = itemPos.m_82546_(conduitPos).m_82541_();
            float angle = (float)Math.atan(-(direction.f_82481_ / direction.f_82479_));
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(angle * 57.295776f));
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            itemRenderer.m_115143_(stack, ItemTransforms.TransformType.GROUND, true, poseStack, bufferSource, packedLight, overlay, ibakedmodel);
            poseStack.m_85849_();
        }
    }

    private void renderFloatingItem(@NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int overlay, Vec3 conduitPos, ItemRenderer itemRenderer, Vec3 itemPos, ItemStack stack, BakedModel ibakedmodel) {
        poseStack.m_85836_();
        poseStack.m_85837_(-conduitPos.f_82479_ + 0.5, -conduitPos.f_82480_ + 0.5, -conduitPos.f_82481_ + 0.5);
        poseStack.m_85837_(itemPos.f_82479_, itemPos.f_82480_, itemPos.f_82481_);
        Vec3 direction = itemPos.m_82546_(conduitPos).m_82541_();
        float angle = (float)Math.atan(-(direction.f_82481_ / direction.f_82479_));
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(angle * 57.295776f));
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        itemRenderer.m_115143_(stack, ItemTransforms.TransformType.GROUND, true, poseStack, bufferSource, packedLight, overlay, ibakedmodel);
        poseStack.m_85849_();
    }
}

