/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vaultintegrations.data;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;

public class AltarConduitData
extends SavedData {
    private static final String DATA_NAME = "altar_conduit";
    private HashMap<UUID, BlockPos> playerConduitLocation = new HashMap();

    public boolean setConduitLocation(ServerPlayer player, BlockPos pos) {
        if (this.playerConduitLocation.containsKey(player.m_142081_())) {
            return false;
        }
        this.playerConduitLocation.put(player.m_142081_(), pos);
        this.m_77762_();
        return true;
    }

    public void removeConduitLocation(ServerPlayer player) {
        this.removeConduitLocation(player.m_142081_());
    }

    public void removeConduitLocation(UUID playerId) {
        if (this.playerConduitLocation.containsKey(playerId)) {
            this.playerConduitLocation.remove(playerId);
            this.m_77762_();
        }
    }

    public void removeConduitLocation(BlockPos pos) {
        UUID foundId = null;
        for (Map.Entry<UUID, BlockPos> entry : this.playerConduitLocation.entrySet()) {
            if (!entry.getValue().equals((Object)pos)) continue;
            foundId = entry.getKey();
            break;
        }
        if (foundId != null) {
            this.removeConduitLocation(foundId);
        }
    }

    public BlockPos getConduitLocation(ServerPlayer player) {
        return this.playerConduitLocation.getOrDefault(player.m_142081_(), BlockPos.f_121853_);
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag tag) {
        this.playerConduitLocation.forEach((uuid, blockPos) -> tag.m_128365_(uuid.toString(), (Tag)NbtUtils.m_129224_((BlockPos)blockPos)));
        return tag;
    }

    public void load(CompoundTag tag) {
        tag.m_128431_().forEach(k -> this.playerConduitLocation.put(UUID.fromString(k), NbtUtils.m_129239_((CompoundTag)tag.m_128469_(k))));
    }

    private static <T extends SavedData> T fromTag(CompoundTag tag) {
        AltarConduitData data = new AltarConduitData();
        data.load(tag);
        return (T)((Object)data);
    }

    public static AltarConduitData get(@NotNull MinecraftServer server) {
        return (AltarConduitData)server.m_129783_().m_8895_().m_164861_(AltarConduitData::fromTag, AltarConduitData::new, DATA_NAME);
    }
}

