/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vaultintegrations.inventory;

import iskallia.vaultintegrations.block.entity.base.BaseBlockEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;

public abstract class BaseItemContainer<T extends BaseBlockEntity>
implements Container,
INBTSerializable<CompoundTag> {
    private final T blockEntity;
    private final int size;
    protected final NonNullList<ItemStack> items;

    public BaseItemContainer(T blockEntity, int size) {
        this.blockEntity = blockEntity;
        this.size = size;
        this.items = NonNullList.m_122780_((int)this.size, (Object)ItemStack.f_41583_);
    }

    public abstract boolean isItemValid(ItemStack var1);

    public T getBlockEntity() {
        return this.blockEntity;
    }

    public int getSize() {
        return this.size;
    }

    public boolean m_7013_(int slotIndex, ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        ItemStack stackInSlot = this.m_8020_(slotIndex);
        return this.isItemValid(stack);
    }

    public int m_6643_() {
        return this.getSize();
    }

    public boolean m_7983_() {
        return this.items.stream().allMatch(ItemStack::m_41619_);
    }

    @NotNull
    public ItemStack m_8020_(int index) {
        return index >= 0 && index < this.items.size() ? (ItemStack)this.items.get(index) : ItemStack.f_41583_;
    }

    @NotNull
    public ItemStack m_7407_(int index, int count) {
        ItemStack remove = (ItemStack)this.items.get(index);
        if (!remove.m_41619_()) {
            this.items.set(index, (Object)ItemStack.f_41583_);
        }
        this.m_6596_();
        return remove;
    }

    @NotNull
    public ItemStack m_8016_(int index) {
        return (ItemStack)this.items.remove(index);
    }

    public ItemStack addItem(@NotNull ItemStack stack) {
        ItemStack copy = stack.m_41777_();
        for (int i = 0; i < this.getSize(); ++i) {
            ItemStack stackInSlot = this.m_8020_(i);
            if (!stackInSlot.m_41619_() || !this.m_7013_(i, stack)) continue;
            ItemStack remainder = copy.m_41620_(this.m_6893_());
            this.m_6836_(i, remainder);
            return copy;
        }
        return copy;
    }

    public void m_6836_(int index, @NotNull ItemStack stack) {
        ItemStack stackInSlot = this.m_8020_(index);
        if (this.m_7013_(index, stack)) {
            ItemStack remainder = stack.m_41620_(this.m_6893_());
            this.items.set(index, (Object)remainder);
            this.m_6596_();
        }
    }

    public void m_6596_() {
        ((BaseBlockEntity)((Object)this.blockEntity)).sendUpdates();
    }

    public boolean m_6542_(@NotNull Player player) {
        return ((BaseBlockEntity)((Object)this.blockEntity)).stillValid(player);
    }

    public List<ItemStack> getStacks() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int slot = 0; slot < this.m_6643_(); ++slot) {
            ItemStack stack = this.m_8020_(slot);
            if (stack.m_41619_()) continue;
            stacks.add(stack);
        }
        return Collections.unmodifiableList(stacks);
    }

    public void m_6211_() {
        this.items.clear();
        this.m_6596_();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag items = new ListTag();
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack stack = (ItemStack)this.items.get(i);
            if (stack.m_41619_()) continue;
            CompoundTag stackTag = new CompoundTag();
            stackTag.m_128405_("slot", i);
            stackTag.m_128365_("stack", (Tag)stack.serializeNBT());
            items.add((Object)stackTag);
        }
        tag.m_128365_("items", (Tag)items);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.items.clear();
        ListTag items = tag.m_128437_("items", 10);
        for (int i = 0; i < items.size(); ++i) {
            CompoundTag stackTag = items.m_128728_(i);
            int slot = stackTag.m_128451_("slot");
            this.items.set(slot, (Object)ItemStack.m_41712_((CompoundTag)stackTag.m_128469_("stack")));
        }
    }
}

