/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.mounted;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.contraptions.mounted.CartAssembleRailType;
import com.simibubi.create.content.contraptions.mounted.CartAssemblerBlockEntity;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.redstone.rail.ControllerRailBlock;
import com.simibubi.create.content.schematics.requirement.ISpecialBlockItemRequirement;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.block.IBE;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.MinecartChest;
import net.minecraft.world.entity.vehicle.MinecartFurnace;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CartAssemblerBlock
extends BaseRailBlock
implements IBE<CartAssemblerBlockEntity>,
IWrenchable,
ISpecialBlockItemRequirement {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty BACKWARDS = BooleanProperty.m_61465_((String)"backwards");
    public static final Property<RailShape> RAIL_SHAPE = EnumProperty.m_61598_((String)"shape", RailShape.class, (Enum[])new RailShape[]{RailShape.EAST_WEST, RailShape.NORTH_SOUTH});
    public static final Property<CartAssembleRailType> RAIL_TYPE = EnumProperty.m_61587_((String)"rail_type", CartAssembleRailType.class);

    public CartAssemblerBlock(BlockBehaviour.Properties properties) {
        super(true, properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BACKWARDS, (Comparable)Boolean.valueOf(false))).m_61124_(RAIL_TYPE, (Comparable)((Object)CartAssembleRailType.POWERED_RAIL))).m_61124_((Property)f_152149_, (Comparable)Boolean.valueOf(false)));
    }

    public static BlockState createAnchor(BlockState state) {
        Direction.Axis axis = state.m_61143_(RAIL_SHAPE) == RailShape.NORTH_SOUTH ? Direction.Axis.Z : Direction.Axis.X;
        return (BlockState)AllBlocks.MINECART_ANCHOR.getDefaultState().m_61124_((Property)BlockStateProperties.f_61364_, (Comparable)axis);
    }

    private static Item getRailItem(BlockState state) {
        return ((CartAssembleRailType)((Object)state.m_61143_(RAIL_TYPE))).getItem();
    }

    public static BlockState getRailBlock(BlockState state) {
        BaseRailBlock railBlock = (BaseRailBlock)((CartAssembleRailType)((Object)state.m_61143_(RAIL_TYPE))).getBlock();
        BlockState railState = (BlockState)railBlock.m_49966_().m_61124_(railBlock.m_7978_(), (Comparable)((RailShape)state.m_61143_(RAIL_SHAPE)));
        if (railState.m_61138_((Property)ControllerRailBlock.BACKWARDS)) {
            railState = (BlockState)railState.m_61124_((Property)ControllerRailBlock.BACKWARDS, (Comparable)((Boolean)state.m_61143_((Property)BACKWARDS)));
        }
        return railState;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{RAIL_SHAPE, POWERED, RAIL_TYPE, BACKWARDS, f_152149_});
        super.m_7926_(builder);
    }

    public boolean canMakeSlopes(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos) {
        return false;
    }

    public void onMinecartPass(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, AbstractMinecart cart) {
        if (!CartAssemblerBlock.canAssembleTo(cart)) {
            return;
        }
        if (world.f_46443_) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)world, pos, be -> be.assembleNextTick(cart));
    }

    public static CartAssemblerAction getActionForCart(BlockState state, AbstractMinecart cart) {
        CartAssembleRailType type = (CartAssembleRailType)((Object)state.m_61143_(RAIL_TYPE));
        boolean powered = (Boolean)state.m_61143_((Property)POWERED);
        switch (type) {
            case ACTIVATOR_RAIL: {
                return powered ? CartAssemblerAction.DISASSEMBLE : CartAssemblerAction.PASS;
            }
            case CONTROLLER_RAIL: {
                return powered ? CartAssemblerAction.ASSEMBLE_ACCELERATE_DIRECTIONAL : CartAssemblerAction.DISASSEMBLE_BRAKE;
            }
            case DETECTOR_RAIL: {
                return cart.m_20197_().isEmpty() ? CartAssemblerAction.ASSEMBLE_ACCELERATE : CartAssemblerAction.DISASSEMBLE;
            }
            case POWERED_RAIL: {
                return powered ? CartAssemblerAction.ASSEMBLE_ACCELERATE : CartAssemblerAction.DISASSEMBLE_BRAKE;
            }
            case REGULAR: {
                return powered ? CartAssemblerAction.ASSEMBLE : CartAssemblerAction.DISASSEMBLE;
            }
        }
        return CartAssemblerAction.PASS;
    }

    public static boolean canAssembleTo(AbstractMinecart cart) {
        return cart.canBeRidden() || cart instanceof MinecartFurnace || cart instanceof MinecartChest;
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult blockRayTraceResult) {
        ItemStack itemStack = player.m_21120_(hand);
        Item previousItem = CartAssemblerBlock.getRailItem(state);
        Item heldItem = itemStack.m_41720_();
        if (heldItem != previousItem) {
            CartAssembleRailType newType = null;
            for (CartAssembleRailType type : CartAssembleRailType.values()) {
                if (heldItem != type.getItem()) continue;
                newType = type;
            }
            if (newType == null) {
                return InteractionResult.PASS;
            }
            world.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.PLAYERS, 1.0f, 1.0f);
            world.m_46597_(pos, (BlockState)state.m_61124_(RAIL_TYPE, (Comparable)((Object)newType)));
            if (!player.m_7500_()) {
                itemStack.m_41774_(1);
                player.m_150109_().m_150079_(new ItemStack((ItemLike)previousItem));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6861_(@Nonnull BlockState state, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull Block blockIn, @Nonnull BlockPos fromPos, boolean isMoving) {
        if (worldIn.f_46443_) {
            return;
        }
        boolean previouslyPowered = (Boolean)state.m_61143_((Property)POWERED);
        if (previouslyPowered != worldIn.m_46753_(pos)) {
            worldIn.m_7731_(pos, (BlockState)state.m_61122_((Property)POWERED), 2);
        }
        super.m_6861_(state, worldIn, pos, blockIn, fromPos, isMoving);
    }

    @Nonnull
    public Property<RailShape> m_7978_() {
        return RAIL_SHAPE;
    }

    @Nonnull
    public VoxelShape m_5940_(BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return AllShapes.CART_ASSEMBLER.get(this.getRailAxis(state));
    }

    protected Direction.Axis getRailAxis(BlockState state) {
        return state.m_61143_(RAIL_SHAPE) == RailShape.NORTH_SOUTH ? Direction.Axis.Z : Direction.Axis.X;
    }

    @Nonnull
    public VoxelShape m_5939_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, CollisionContext context) {
        if (context instanceof EntityCollisionContext) {
            Entity entity = ((EntityCollisionContext)context).m_193113_();
            if (entity instanceof AbstractMinecart) {
                return Shapes.m_83040_();
            }
            if (entity instanceof Player) {
                return AllShapes.CART_ASSEMBLER_PLAYER_COLLISION.get(this.getRailAxis(state));
            }
        }
        return Shapes.m_83144_();
    }

    @Nonnull
    public PushReaction m_5537_(@Nonnull BlockState state) {
        return PushReaction.BLOCK;
    }

    @Override
    public Class<CartAssemblerBlockEntity> getBlockEntityClass() {
        return CartAssemblerBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends CartAssemblerBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.CART_ASSEMBLER.get();
    }

    public boolean m_7898_(@Nonnull BlockState state, @Nonnull LevelReader world, @Nonnull BlockPos pos) {
        return false;
    }

    @Override
    public ItemRequirement getRequiredItems(BlockState state, BlockEntity be) {
        ArrayList<ItemStack> requiredItems = new ArrayList<ItemStack>();
        requiredItems.add(new ItemStack((ItemLike)CartAssemblerBlock.getRailItem(state)));
        requiredItems.add(new ItemStack((ItemLike)this.m_5456_()));
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, requiredItems);
    }

    @Nonnull
    public List<ItemStack> m_7381_(@Nonnull BlockState state, @Nonnull LootContext.Builder builder) {
        List drops = super.m_7381_(state, builder);
        drops.addAll(CartAssemblerBlock.getRailBlock(state).m_60724_(builder));
        return drops;
    }

    public List<ItemStack> getDropsNoRail(BlockState state, ServerLevel world, BlockPos pos, @Nullable BlockEntity p_220077_3_, @Nullable Entity p_220077_4_, ItemStack p_220077_5_) {
        return super.m_7381_(state, new LootContext.Builder(world).m_78977_(world.f_46441_).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82528_((Vec3i)pos)).m_78972_(LootContextParams.f_81463_, (Object)p_220077_5_).m_78984_(LootContextParams.f_81455_, (Object)p_220077_4_).m_78984_(LootContextParams.f_81462_, (Object)p_220077_3_));
    }

    @Override
    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (player != null && !player.m_7500_()) {
            this.getDropsNoRail(state, (ServerLevel)world, pos, world.m_7702_(pos), (Entity)player, context.m_43722_()).forEach(itemStack -> player.m_150109_().m_150079_(itemStack));
        }
        if (world instanceof ServerLevel) {
            state.m_60612_((ServerLevel)world, pos, ItemStack.f_41583_);
        }
        world.m_46597_(pos, CartAssemblerBlock.getRailBlock(state));
        return InteractionResult.SUCCESS;
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }

    @Override
    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        Level world = context.m_43725_();
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockPos pos = context.m_8083_();
        world.m_7731_(pos, this.m_6843_(state, Rotation.CLOCKWISE_90), 3);
        world.m_46672_(pos.m_7495_(), (Block)this);
        return InteractionResult.SUCCESS;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        if (rotation == Rotation.NONE) {
            return state;
        }
        BlockState base = ((BlockState)((BlockState)AllBlocks.CONTROLLER_RAIL.getDefaultState().m_61124_(ControllerRailBlock.SHAPE, (Comparable)((RailShape)state.m_61143_(RAIL_SHAPE)))).m_61124_((Property)ControllerRailBlock.BACKWARDS, (Comparable)((Boolean)state.m_61143_((Property)BACKWARDS)))).m_60717_(rotation);
        return (BlockState)((BlockState)state.m_61124_(RAIL_SHAPE, (Comparable)((RailShape)base.m_61143_(ControllerRailBlock.SHAPE)))).m_61124_((Property)BACKWARDS, (Comparable)((Boolean)base.m_61143_((Property)ControllerRailBlock.BACKWARDS)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        if (mirror == Mirror.NONE) {
            return state;
        }
        BlockState base = ((BlockState)((BlockState)AllBlocks.CONTROLLER_RAIL.getDefaultState().m_61124_(ControllerRailBlock.SHAPE, (Comparable)((RailShape)state.m_61143_(RAIL_SHAPE)))).m_61124_((Property)ControllerRailBlock.BACKWARDS, (Comparable)((Boolean)state.m_61143_((Property)BACKWARDS)))).m_60715_(mirror);
        return (BlockState)state.m_61124_((Property)BACKWARDS, (Comparable)((Boolean)base.m_61143_((Property)ControllerRailBlock.BACKWARDS)));
    }

    public static Direction getHorizontalDirection(BlockState blockState) {
        if (!(blockState.m_60734_() instanceof CartAssemblerBlock)) {
            return Direction.SOUTH;
        }
        Direction pointingTo = CartAssemblerBlock.getPointingTowards(blockState);
        return (Boolean)blockState.m_61143_((Property)BACKWARDS) != false ? pointingTo.m_122424_() : pointingTo;
    }

    private static Direction getPointingTowards(BlockState state) {
        switch ((RailShape)state.m_61143_(RAIL_SHAPE)) {
            case EAST_WEST: {
                return Direction.WEST;
            }
        }
        return Direction.NORTH;
    }

    public static enum CartAssemblerAction {
        ASSEMBLE,
        DISASSEMBLE,
        ASSEMBLE_ACCELERATE,
        DISASSEMBLE_BRAKE,
        ASSEMBLE_ACCELERATE_DIRECTIONAL,
        PASS;


        public boolean shouldAssemble() {
            return this == ASSEMBLE || this == ASSEMBLE_ACCELERATE || this == ASSEMBLE_ACCELERATE_DIRECTIONAL;
        }

        public boolean shouldDisassemble() {
            return this == DISASSEMBLE || this == DISASSEMBLE_BRAKE;
        }
    }

    public static class MinecartAnchorBlock
    extends Block {
        public MinecartAnchorBlock(BlockBehaviour.Properties p_i48440_1_) {
            super(p_i48440_1_);
        }

        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            builder.m_61104_(new Property[]{BlockStateProperties.f_61364_});
            super.m_7926_(builder);
        }

        @Nonnull
        public VoxelShape m_5940_(@Nonnull BlockState p_220053_1_, @Nonnull BlockGetter p_220053_2_, @Nonnull BlockPos p_220053_3_, @Nonnull CollisionContext p_220053_4_) {
            return Shapes.m_83040_();
        }
    }
}

