/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.decoration.girder;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllShapes;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.decoration.bracket.BracketBlock;
import com.simibubi.create.content.decoration.bracket.BracketedBlockEntityBehaviour;
import com.simibubi.create.content.decoration.girder.GirderEncasedShaftBlock;
import com.simibubi.create.content.decoration.girder.GirderPlacementHelper;
import com.simibubi.create.content.decoration.girder.GirderWrenchBehavior;
import com.simibubi.create.content.decoration.placard.PlacardBlock;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.logistics.chute.AbstractChuteBlock;
import com.simibubi.create.content.redstone.nixieTube.NixieTubeBlock;
import com.simibubi.create.content.trains.display.FlapDisplayBlock;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackShape;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.placement.IPlacementHelper;
import com.simibubi.create.foundation.placement.PlacementHelpers;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GirderBlock
extends Block
implements SimpleWaterloggedBlock,
IWrenchable {
    private static final int placementHelperId = PlacementHelpers.register(new GirderPlacementHelper());
    public static final BooleanProperty X = BooleanProperty.m_61465_((String)"x");
    public static final BooleanProperty Z = BooleanProperty.m_61465_((String)"z");
    public static final BooleanProperty TOP = BooleanProperty.m_61465_((String)"top");
    public static final BooleanProperty BOTTOM = BooleanProperty.m_61465_((String)"bottom");
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61365_;

    public GirderBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false))).m_61124_(AXIS, (Comparable)Direction.Axis.Y)).m_61124_((Property)TOP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(false))).m_61124_((Property)X, (Comparable)Boolean.valueOf(false))).m_61124_((Property)Z, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder.m_61104_(new Property[]{X, Z, TOP, BOTTOM, AXIS, BlockStateProperties.f_61362_}));
    }

    public VoxelShape m_7947_(BlockState pState, BlockGetter pReader, BlockPos pPos) {
        return Shapes.m_83110_((VoxelShape)super.m_7947_(pState, pReader, pPos), (VoxelShape)AllShapes.EIGHT_VOXEL_POLE.get(Direction.Axis.Y));
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pPlayer == null) {
            return InteractionResult.PASS;
        }
        ItemStack itemInHand = pPlayer.m_21120_(pHand);
        if (AllBlocks.SHAFT.isIn(itemInHand)) {
            KineticBlockEntity.switchToBlockState(pLevel, pPos, (BlockState)((BlockState)((BlockState)((BlockState)AllBlocks.METAL_GIRDER_ENCASED_SHAFT.getDefaultState().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)((Boolean)pState.m_61143_((Property)BlockStateProperties.f_61362_)))).m_61124_((Property)TOP, (Comparable)((Boolean)pState.m_61143_((Property)TOP)))).m_61124_((Property)BOTTOM, (Comparable)((Boolean)pState.m_61143_((Property)BOTTOM)))).m_61124_(GirderEncasedShaftBlock.HORIZONTAL_AXIS, (Comparable)((Boolean)pState.m_61143_((Property)X) != false || pHit.m_82434_().m_122434_() == Direction.Axis.Z ? Direction.Axis.Z : Direction.Axis.X)));
            pLevel.m_5594_(null, pPos, SoundEvents.f_12201_, SoundSource.BLOCKS, 0.5f, 1.25f);
            if (!pLevel.f_46443_ && !pPlayer.m_7500_()) {
                itemInHand.m_41774_(1);
                if (itemInHand.m_41619_()) {
                    pPlayer.m_21008_(pHand, ItemStack.f_41583_);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (AllItems.WRENCH.isIn(itemInHand) && !pPlayer.m_20161_()) {
            if (GirderWrenchBehavior.handleClick(pLevel, pPos, pState, pHit)) {
                return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
            }
            return InteractionResult.FAIL;
        }
        IPlacementHelper helper = PlacementHelpers.get(placementHelperId);
        if (helper.matchesItem(itemInHand)) {
            return helper.getOffset(pPlayer, pLevel, pState, pPos, pHit).placeInWorld(pLevel, (BlockItem)itemInHand.m_41720_(), pPlayer, pHand, pHit);
        }
        return InteractionResult.PASS;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    @Override
    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        return InteractionResult.PASS;
    }

    public void m_7458_(BlockState p_60462_, ServerLevel p_60463_, BlockPos p_60464_, Random p_60465_) {
        Block.m_49902_((BlockState)p_60462_, (BlockState)Block.m_49931_((BlockState)p_60462_, (LevelAccessor)p_60463_, (BlockPos)p_60464_), (LevelAccessor)p_60463_, (BlockPos)p_60464_, (int)3);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighbourState, LevelAccessor world, BlockPos pos, BlockPos neighbourPos) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        Direction.Axis axis = direction.m_122434_();
        if (direction.m_122434_() != Direction.Axis.Y) {
            if (state.m_61143_(AXIS) != direction.m_122434_()) {
                BooleanProperty updateProperty;
                BooleanProperty booleanProperty = axis == Direction.Axis.X ? X : (axis == Direction.Axis.Z ? Z : (updateProperty = direction == Direction.UP ? TOP : BOTTOM));
                if (!GirderBlock.isConnected((BlockAndTintGetter)world, pos, state, direction) && !GirderBlock.isConnected((BlockAndTintGetter)world, pos, state, direction.m_122424_())) {
                    state = (BlockState)state.m_61124_((Property)updateProperty, (Comparable)Boolean.valueOf(false));
                }
            }
        } else if (state.m_61143_(AXIS) != Direction.Axis.Y) {
            if (world.m_8055_(pos.m_7494_()).m_60816_((BlockGetter)world, pos.m_7494_()).m_83281_()) {
                state = (BlockState)state.m_61124_((Property)TOP, (Comparable)Boolean.valueOf(false));
            }
            if (world.m_8055_(pos.m_7495_()).m_60816_((BlockGetter)world, pos.m_7495_()).m_83281_()) {
                state = (BlockState)state.m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(false));
            }
        }
        for (Direction d : Iterate.directionsInAxis(axis)) {
            state = GirderBlock.updateState(world, pos, state, d);
        }
        return state;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction face = context.m_43719_();
        FluidState ifluidstate = level.m_6425_(pos);
        BlockState state = super.m_5573_(context);
        state = (BlockState)state.m_61124_((Property)X, (Comparable)Boolean.valueOf(face.m_122434_() == Direction.Axis.X));
        state = (BlockState)state.m_61124_((Property)Z, (Comparable)Boolean.valueOf(face.m_122434_() == Direction.Axis.Z));
        state = (BlockState)state.m_61124_(AXIS, (Comparable)face.m_122434_());
        for (Direction d : Iterate.directions) {
            state = GirderBlock.updateState((LevelAccessor)level, pos, state, d);
        }
        return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(ifluidstate.m_76152_() == Fluids.f_76193_));
    }

    public static BlockState updateState(LevelAccessor level, BlockPos pos, BlockState state, Direction d) {
        Direction.Axis axis = d.m_122434_();
        BooleanProperty updateProperty = axis == Direction.Axis.X ? X : (axis == Direction.Axis.Z ? Z : (d == Direction.UP ? TOP : BOTTOM));
        BlockState sideState = level.m_8055_(pos.m_142300_(d));
        if (axis.m_122478_()) {
            return GirderBlock.updateVerticalProperty(level, pos, state, (Property<Boolean>)updateProperty, sideState, d);
        }
        if (state.m_61143_(AXIS) == axis) {
            state = (BlockState)state.m_61124_((Property)updateProperty, (Comparable)Boolean.valueOf(true));
        } else if (sideState.m_60734_() instanceof GirderEncasedShaftBlock && sideState.m_61143_(GirderEncasedShaftBlock.HORIZONTAL_AXIS) != axis) {
            state = (BlockState)state.m_61124_((Property)updateProperty, (Comparable)Boolean.valueOf(true));
        } else if (sideState.m_60734_() == state.m_60734_() && ((Boolean)sideState.m_61143_((Property)updateProperty)).booleanValue()) {
            state = (BlockState)state.m_61124_((Property)updateProperty, (Comparable)Boolean.valueOf(true));
        } else if (sideState.m_60734_() instanceof NixieTubeBlock && NixieTubeBlock.getFacing(sideState) == d) {
            state = (BlockState)state.m_61124_((Property)updateProperty, (Comparable)Boolean.valueOf(true));
        } else if (sideState.m_60734_() instanceof PlacardBlock && PlacardBlock.connectedDirection(sideState) == d) {
            state = (BlockState)state.m_61124_((Property)updateProperty, (Comparable)Boolean.valueOf(true));
        } else if (GirderBlock.isFacingBracket((BlockAndTintGetter)level, pos, d)) {
            state = (BlockState)state.m_61124_((Property)updateProperty, (Comparable)Boolean.valueOf(true));
        }
        for (Direction d2 : Iterate.directionsInAxis(axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X)) {
            TrackShape shape;
            BlockState above = level.m_8055_(pos.m_7494_().m_142300_(d2));
            if (!AllTags.AllBlockTags.GIRDABLE_TRACKS.matches(above) || (shape = (TrackShape)((Object)above.m_61143_(TrackBlock.SHAPE))) != (axis == Direction.Axis.X ? TrackShape.XO : TrackShape.ZO)) continue;
            state = (BlockState)state.m_61124_((Property)updateProperty, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public static boolean isFacingBracket(BlockAndTintGetter level, BlockPos pos, Direction d) {
        BlockEntity blockEntity = level.m_7702_(pos.m_142300_(d));
        if (!(blockEntity instanceof SmartBlockEntity)) {
            return false;
        }
        SmartBlockEntity sbe = (SmartBlockEntity)blockEntity;
        BracketedBlockEntityBehaviour behaviour = sbe.getBehaviour(BracketedBlockEntityBehaviour.TYPE);
        if (behaviour == null) {
            return false;
        }
        BlockState bracket = behaviour.getBracket();
        if (bracket == null || !bracket.m_61138_((Property)BracketBlock.f_52588_)) {
            return false;
        }
        return bracket.m_61143_((Property)BracketBlock.f_52588_) == d;
    }

    public static BlockState updateVerticalProperty(LevelAccessor level, BlockPos pos, BlockState state, Property<Boolean> updateProperty, BlockState sideState, Direction d) {
        boolean canAttach = false;
        if (state.m_61138_(AXIS) && state.m_61143_(AXIS) == Direction.Axis.Y) {
            canAttach = true;
        } else if (GirderBlock.isGirder(sideState) && GirderBlock.isXGirder(sideState) == GirderBlock.isZGirder(sideState)) {
            canAttach = true;
        } else if (GirderBlock.isGirder(sideState)) {
            canAttach = true;
        } else if (sideState.m_61138_((Property)WallBlock.f_57949_) && ((Boolean)sideState.m_61143_((Property)WallBlock.f_57949_)).booleanValue()) {
            canAttach = true;
        } else if (sideState.m_60734_() instanceof NixieTubeBlock && NixieTubeBlock.getFacing(sideState) == d) {
            canAttach = true;
        } else if (sideState.m_60734_() instanceof FlapDisplayBlock) {
            canAttach = true;
        } else if (sideState.m_60734_() instanceof LanternBlock && d == Direction.DOWN == (Boolean)sideState.m_61143_((Property)LanternBlock.f_153459_)) {
            canAttach = true;
        } else if (sideState.m_60734_() instanceof ChainBlock && sideState.m_61143_((Property)ChainBlock.f_55923_) == Direction.Axis.Y) {
            canAttach = true;
        } else if (sideState.m_61138_((Property)FaceAttachedHorizontalDirectionalBlock.f_53179_)) {
            if (sideState.m_61143_((Property)FaceAttachedHorizontalDirectionalBlock.f_53179_) == AttachFace.CEILING && d == Direction.DOWN) {
                canAttach = true;
            } else if (sideState.m_61143_((Property)FaceAttachedHorizontalDirectionalBlock.f_53179_) == AttachFace.FLOOR && d == Direction.UP) {
                canAttach = true;
            }
        } else if (sideState.m_60734_() instanceof PlacardBlock && PlacardBlock.connectedDirection(sideState) == d) {
            canAttach = true;
        } else if (GirderBlock.isFacingBracket((BlockAndTintGetter)level, pos, d)) {
            canAttach = true;
        }
        if (canAttach) {
            return (BlockState)state.m_61124_(updateProperty, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public static boolean isGirder(BlockState state) {
        return state.m_60734_() instanceof GirderBlock || state.m_60734_() instanceof GirderEncasedShaftBlock;
    }

    public static boolean isXGirder(BlockState state) {
        return state.m_60734_() instanceof GirderBlock && (Boolean)state.m_61143_((Property)X) != false || state.m_60734_() instanceof GirderEncasedShaftBlock && state.m_61143_(GirderEncasedShaftBlock.HORIZONTAL_AXIS) == Direction.Axis.Z;
    }

    public static boolean isZGirder(BlockState state) {
        return state.m_60734_() instanceof GirderBlock && (Boolean)state.m_61143_((Property)Z) != false || state.m_60734_() instanceof GirderEncasedShaftBlock && state.m_61143_(GirderEncasedShaftBlock.HORIZONTAL_AXIS) == Direction.Axis.X;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        boolean x = (Boolean)state.m_61143_((Property)X);
        boolean z = (Boolean)state.m_61143_((Property)Z);
        return x ? (z ? AllShapes.GIRDER_CROSS : AllShapes.GIRDER_BEAM.get(Direction.Axis.X)) : (z ? AllShapes.GIRDER_BEAM.get(Direction.Axis.Z) : AllShapes.EIGHT_VOXEL_POLE.get(Direction.Axis.Y));
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }

    public static boolean isConnected(BlockAndTintGetter world, BlockPos pos, BlockState state, Direction side) {
        Direction.Axis axis = side.m_122434_();
        if (state.m_60734_() instanceof GirderBlock && !((Boolean)state.m_61143_((Property)(axis == Direction.Axis.X ? X : Z))).booleanValue()) {
            return false;
        }
        if (state.m_60734_() instanceof GirderEncasedShaftBlock && state.m_61143_(GirderEncasedShaftBlock.HORIZONTAL_AXIS) == axis) {
            return false;
        }
        BlockPos relative = pos.m_142300_(side);
        BlockState blockState = world.m_8055_(relative);
        if (blockState.m_60795_()) {
            return false;
        }
        if (blockState.m_60734_() instanceof NixieTubeBlock && NixieTubeBlock.getFacing(blockState) == side) {
            return true;
        }
        if (GirderBlock.isFacingBracket(world, pos, side)) {
            return true;
        }
        if (blockState.m_60734_() instanceof PlacardBlock && PlacardBlock.connectedDirection(blockState) == side) {
            return true;
        }
        VoxelShape shape = blockState.m_60808_((BlockGetter)world, relative);
        if (shape.m_83281_()) {
            return false;
        }
        if (Block.m_49918_((VoxelShape)shape, (Direction)side.m_122424_()) && blockState.m_60767_().m_76337_()) {
            return true;
        }
        return AbstractChuteBlock.getChuteFacing(blockState) == Direction.DOWN;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        state = (BlockState)state.m_61124_(AXIS, (Comparable)rot.m_55954_(Direction.m_122387_((Direction.Axis)((Direction.Axis)state.m_61143_(AXIS)), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE)).m_122434_());
        if (rot.m_55954_(Direction.EAST).m_122434_() == Direction.Axis.X) {
            return state;
        }
        return (BlockState)((BlockState)state.m_61124_((Property)X, (Comparable)((Boolean)state.m_61143_((Property)Z)))).m_61124_((Property)Z, (Comparable)((Boolean)state.m_61143_((Property)Z)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state;
    }
}

