/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.potatoCannon;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import com.simibubi.create.AllItems;
import com.simibubi.create.Create;
import com.simibubi.create.content.equipment.potatoCannon.PotatoCannonProjectileType;
import com.simibubi.create.foundation.mixin.accessor.FallingBlockEntityAccessor;
import com.simibubi.create.foundation.utility.WorldAttached;
import java.util.UUID;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.food.Foods;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;

public class BuiltinPotatoProjectileTypes {
    private static final GameProfile ZOMBIE_CONVERTER_NAME = new GameProfile(UUID.fromString("be12d3dc-27d3-4992-8c97-66be53fd49c5"), "Converter");
    private static final WorldAttached<FakePlayer> ZOMBIE_CONVERTERS = new WorldAttached<FakePlayer>(w -> new FakePlayer((ServerLevel)w, ZOMBIE_CONVERTER_NAME));
    public static final PotatoCannonProjectileType FALLBACK = BuiltinPotatoProjectileTypes.create("fallback").damage(0).register();
    public static final PotatoCannonProjectileType POTATO = BuiltinPotatoProjectileTypes.create("potato").damage(5).reloadTicks(15).velocity(1.25f).knockback(1.5f).renderTumbling().onBlockHit(BuiltinPotatoProjectileTypes.plantCrop(Blocks.f_50250_)).registerAndAssign(new ItemLike[]{Items.f_42620_});
    public static final PotatoCannonProjectileType BAKED_POTATO = BuiltinPotatoProjectileTypes.create("baked_potato").damage(5).reloadTicks(15).velocity(1.25f).knockback(0.5f).renderTumbling().preEntityHit(BuiltinPotatoProjectileTypes.setFire(3)).registerAndAssign(new ItemLike[]{Items.f_42674_});
    public static final PotatoCannonProjectileType CARROT = BuiltinPotatoProjectileTypes.create("carrot").damage(4).reloadTicks(12).velocity(1.45f).knockback(0.3f).renderTowardMotion(140, 1.0f).soundPitch(1.5f).onBlockHit(BuiltinPotatoProjectileTypes.plantCrop(Blocks.f_50249_)).registerAndAssign(new ItemLike[]{Items.f_42619_});
    public static final PotatoCannonProjectileType GOLDEN_CARROT = BuiltinPotatoProjectileTypes.create("golden_carrot").damage(12).reloadTicks(15).velocity(1.45f).knockback(0.5f).renderTowardMotion(140, 2.0f).soundPitch(1.5f).registerAndAssign(new ItemLike[]{Items.f_42677_});
    public static final PotatoCannonProjectileType SWEET_BERRIES = BuiltinPotatoProjectileTypes.create("sweet_berry").damage(3).reloadTicks(10).knockback(0.1f).velocity(1.05f).renderTumbling().splitInto(3).soundPitch(1.25f).registerAndAssign(new ItemLike[]{Items.f_42780_});
    public static final PotatoCannonProjectileType GLOW_BERRIES = BuiltinPotatoProjectileTypes.create("glow_berry").damage(2).reloadTicks(10).knockback(0.05f).velocity(1.05f).renderTumbling().splitInto(2).soundPitch(1.2f).onEntityHit(BuiltinPotatoProjectileTypes.potion(MobEffects.f_19619_, 1, 200, false)).registerAndAssign(new ItemLike[]{Items.f_151079_});
    public static final PotatoCannonProjectileType CHOCOLATE_BERRIES = BuiltinPotatoProjectileTypes.create("chocolate_berry").damage(4).reloadTicks(10).knockback(0.2f).velocity(1.05f).renderTumbling().splitInto(3).soundPitch(1.25f).registerAndAssign((ItemLike)AllItems.CHOCOLATE_BERRIES.get());
    public static final PotatoCannonProjectileType POISON_POTATO = BuiltinPotatoProjectileTypes.create("poison_potato").damage(5).reloadTicks(15).knockback(0.05f).velocity(1.25f).renderTumbling().onEntityHit(BuiltinPotatoProjectileTypes.potion(MobEffects.f_19614_, 1, 160, true)).registerAndAssign(new ItemLike[]{Items.f_42675_});
    public static final PotatoCannonProjectileType CHORUS_FRUIT = BuiltinPotatoProjectileTypes.create("chorus_fruit").damage(3).reloadTicks(15).velocity(1.2f).knockback(0.05f).renderTumbling().onEntityHit(BuiltinPotatoProjectileTypes.chorusTeleport(20.0)).registerAndAssign(new ItemLike[]{Items.f_42730_});
    public static final PotatoCannonProjectileType APPLE = BuiltinPotatoProjectileTypes.create("apple").damage(5).reloadTicks(10).velocity(1.45f).knockback(0.5f).renderTumbling().soundPitch(1.1f).registerAndAssign(new ItemLike[]{Items.f_42410_});
    public static final PotatoCannonProjectileType HONEYED_APPLE = BuiltinPotatoProjectileTypes.create("honeyed_apple").damage(6).reloadTicks(15).velocity(1.35f).knockback(0.1f).renderTumbling().soundPitch(1.1f).onEntityHit(BuiltinPotatoProjectileTypes.potion(MobEffects.f_19597_, 2, 160, true)).registerAndAssign((ItemLike)AllItems.HONEYED_APPLE.get());
    public static final PotatoCannonProjectileType GOLDEN_APPLE = BuiltinPotatoProjectileTypes.create("golden_apple").damage(1).reloadTicks(100).velocity(1.45f).knockback(0.05f).renderTumbling().soundPitch(1.1f).onEntityHit(ray -> {
        Entity entity = ray.m_82443_();
        Level world = entity.f_19853_;
        if (!(entity instanceof ZombieVillager) || !((ZombieVillager)entity).m_21023_(MobEffects.f_19613_)) {
            return BuiltinPotatoProjectileTypes.foodEffects(Foods.f_38830_, false).test((EntityHitResult)ray);
        }
        if (world.f_46443_) {
            return false;
        }
        FakePlayer dummy = ZOMBIE_CONVERTERS.get((LevelAccessor)world);
        dummy.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42436_, 1));
        ((ZombieVillager)entity).m_6071_((Player)dummy, InteractionHand.MAIN_HAND);
        return true;
    }).registerAndAssign(new ItemLike[]{Items.f_42436_});
    public static final PotatoCannonProjectileType ENCHANTED_GOLDEN_APPLE = BuiltinPotatoProjectileTypes.create("enchanted_golden_apple").damage(1).reloadTicks(100).velocity(1.45f).knockback(0.05f).renderTumbling().soundPitch(1.1f).onEntityHit(BuiltinPotatoProjectileTypes.foodEffects(Foods.f_38829_, false)).registerAndAssign(new ItemLike[]{Items.f_42437_});
    public static final PotatoCannonProjectileType BEETROOT = BuiltinPotatoProjectileTypes.create("beetroot").damage(2).reloadTicks(5).velocity(1.6f).knockback(0.1f).renderTowardMotion(140, 2.0f).soundPitch(1.6f).registerAndAssign(new ItemLike[]{Items.f_42732_});
    public static final PotatoCannonProjectileType MELON_SLICE = BuiltinPotatoProjectileTypes.create("melon_slice").damage(3).reloadTicks(8).knockback(0.1f).velocity(1.45f).renderTumbling().soundPitch(1.5f).registerAndAssign(new ItemLike[]{Items.f_42575_});
    public static final PotatoCannonProjectileType GLISTERING_MELON = BuiltinPotatoProjectileTypes.create("glistering_melon").damage(5).reloadTicks(8).knockback(0.1f).velocity(1.45f).renderTumbling().soundPitch(1.5f).onEntityHit(BuiltinPotatoProjectileTypes.potion(MobEffects.f_19619_, 1, 100, true)).registerAndAssign(new ItemLike[]{Items.f_42546_});
    public static final PotatoCannonProjectileType MELON_BLOCK = BuiltinPotatoProjectileTypes.create("melon_block").damage(8).reloadTicks(20).knockback(2.0f).velocity(0.95f).renderTumbling().soundPitch(0.9f).onBlockHit(BuiltinPotatoProjectileTypes.placeBlockOnGround(Blocks.f_50186_)).registerAndAssign(new ItemLike[]{Blocks.f_50186_});
    public static final PotatoCannonProjectileType PUMPKIN_BLOCK = BuiltinPotatoProjectileTypes.create("pumpkin_block").damage(6).reloadTicks(15).knockback(2.0f).velocity(0.95f).renderTumbling().soundPitch(0.9f).onBlockHit(BuiltinPotatoProjectileTypes.placeBlockOnGround(Blocks.f_50133_)).registerAndAssign(new ItemLike[]{Blocks.f_50133_});
    public static final PotatoCannonProjectileType PUMPKIN_PIE = BuiltinPotatoProjectileTypes.create("pumpkin_pie").damage(7).reloadTicks(15).knockback(0.05f).velocity(1.1f).renderTumbling().sticky().soundPitch(1.1f).registerAndAssign(new ItemLike[]{Items.f_42687_});
    public static final PotatoCannonProjectileType CAKE = BuiltinPotatoProjectileTypes.create("cake").damage(8).reloadTicks(15).knockback(0.1f).velocity(1.1f).renderTumbling().sticky().soundPitch(1.0f).registerAndAssign(new ItemLike[]{Items.f_42502_});
    public static final PotatoCannonProjectileType BLAZE_CAKE = BuiltinPotatoProjectileTypes.create("blaze_cake").damage(15).reloadTicks(20).knockback(0.3f).velocity(1.1f).renderTumbling().sticky().preEntityHit(BuiltinPotatoProjectileTypes.setFire(12)).soundPitch(1.0f).registerAndAssign((ItemLike)AllItems.BLAZE_CAKE.get());

    private static PotatoCannonProjectileType.Builder create(String name) {
        return new PotatoCannonProjectileType.Builder(Create.asResource(name));
    }

    private static Predicate<EntityHitResult> setFire(int seconds) {
        return ray -> {
            ray.m_82443_().m_20254_(seconds);
            return false;
        };
    }

    private static Predicate<EntityHitResult> potion(MobEffect effect, int level, int ticks, boolean recoverable) {
        return ray -> {
            Entity entity = ray.m_82443_();
            if (entity.f_19853_.f_46443_) {
                return true;
            }
            if (entity instanceof LivingEntity) {
                BuiltinPotatoProjectileTypes.applyEffect((LivingEntity)entity, new MobEffectInstance(effect, ticks, level - 1));
            }
            return !recoverable;
        };
    }

    private static Predicate<EntityHitResult> foodEffects(FoodProperties food, boolean recoverable) {
        return ray -> {
            Entity entity = ray.m_82443_();
            if (entity.f_19853_.f_46443_) {
                return true;
            }
            if (entity instanceof LivingEntity) {
                for (Pair effect : food.m_38749_()) {
                    if (!(Create.RANDOM.nextFloat() < ((Float)effect.getSecond()).floatValue())) continue;
                    BuiltinPotatoProjectileTypes.applyEffect((LivingEntity)entity, new MobEffectInstance((MobEffectInstance)effect.getFirst()));
                }
            }
            return !recoverable;
        };
    }

    private static void applyEffect(LivingEntity entity, MobEffectInstance effect) {
        if (effect.m_19544_().m_8093_()) {
            effect.m_19544_().m_19461_(null, null, entity, effect.m_19557_(), 1.0);
        } else {
            entity.m_7292_(effect);
        }
    }

    private static BiPredicate<LevelAccessor, BlockHitResult> plantCrop(Supplier<? extends Block> cropBlock) {
        return (world, ray) -> {
            Level l;
            if (world.m_5776_()) {
                return true;
            }
            BlockPos hitPos = ray.m_82425_();
            if (world instanceof Level && !(l = (Level)world).m_46749_(hitPos)) {
                return true;
            }
            Direction face = ray.m_82434_();
            BlockPos placePos = hitPos.m_142300_(face);
            if (!world.m_8055_(placePos).m_60767_().m_76336_()) {
                return false;
            }
            if (!(cropBlock.get() instanceof IPlantable)) {
                return false;
            }
            BlockState blockState = world.m_8055_(hitPos);
            if (!blockState.canSustainPlant((BlockGetter)world, hitPos, face, (IPlantable)cropBlock.get())) {
                return false;
            }
            world.m_7731_(placePos, ((Block)cropBlock.get()).m_49966_(), 3);
            return true;
        };
    }

    private static BiPredicate<LevelAccessor, BlockHitResult> plantCrop(Block cropBlock) {
        return BuiltinPotatoProjectileTypes.plantCrop((Supplier<? extends Block>)cropBlock.delegate);
    }

    private static BiPredicate<LevelAccessor, BlockHitResult> placeBlockOnGround(Supplier<? extends Block> block) {
        return (world, ray) -> {
            Level l;
            if (world.m_5776_()) {
                return true;
            }
            BlockPos hitPos = ray.m_82425_();
            if (world instanceof Level && !(l = (Level)world).m_46749_(hitPos)) {
                return true;
            }
            Direction face = ray.m_82434_();
            BlockPos placePos = hitPos.m_142300_(face);
            if (!world.m_8055_(placePos).m_60767_().m_76336_()) {
                return false;
            }
            if (face == Direction.UP) {
                world.m_7731_(placePos, ((Block)block.get()).m_49966_(), 3);
            } else if (world instanceof Level) {
                Level level = (Level)world;
                double y = ray.m_82450_().f_82480_ - 0.5;
                if (!world.m_46859_(placePos.m_7494_())) {
                    y = Math.min(y, (double)placePos.m_123342_());
                }
                if (!world.m_46859_(placePos.m_7495_())) {
                    y = Math.max(y, (double)placePos.m_123342_());
                }
                FallingBlockEntity falling = FallingBlockEntityAccessor.create$callInit(level, (double)placePos.m_123341_() + 0.5, y, (double)placePos.m_123343_() + 0.5, ((Block)block.get()).m_49966_());
                falling.f_31942_ = 1;
                world.m_7967_((Entity)falling);
            }
            return true;
        };
    }

    private static BiPredicate<LevelAccessor, BlockHitResult> placeBlockOnGround(Block block) {
        return BuiltinPotatoProjectileTypes.placeBlockOnGround((Supplier<? extends Block>)block.delegate);
    }

    private static Predicate<EntityHitResult> chorusTeleport(double teleportDiameter) {
        return ray -> {
            Entity entity = ray.m_82443_();
            Level world = entity.m_20193_();
            if (world.f_46443_) {
                return true;
            }
            if (!(entity instanceof LivingEntity)) {
                return false;
            }
            LivingEntity livingEntity = (LivingEntity)entity;
            double entityX = livingEntity.m_20185_();
            double entityY = livingEntity.m_20186_();
            double entityZ = livingEntity.m_20189_();
            for (int teleportTry = 0; teleportTry < 16; ++teleportTry) {
                double teleportZ;
                double teleportY;
                double teleportX = entityX + (livingEntity.m_21187_().nextDouble() - 0.5) * teleportDiameter;
                EntityTeleportEvent.ChorusFruit event = ForgeEventFactory.onChorusFruitTeleport((LivingEntity)livingEntity, (double)teleportX, (double)(teleportY = Mth.m_14008_((double)(entityY + (double)(livingEntity.m_21187_().nextInt((int)teleportDiameter) - (int)(teleportDiameter / 2.0))), (double)0.0, (double)(world.m_141928_() - 1))), (double)(teleportZ = entityZ + (livingEntity.m_21187_().nextDouble() - 0.5) * teleportDiameter));
                if (event.isCanceled()) {
                    return false;
                }
                if (!livingEntity.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true)) continue;
                if (livingEntity.m_20159_()) {
                    livingEntity.m_8127_();
                }
                SoundEvent soundevent = livingEntity instanceof Fox ? SoundEvents.f_11953_ : SoundEvents.f_11757_;
                world.m_6263_(null, entityX, entityY, entityZ, soundevent, SoundSource.PLAYERS, 1.0f, 1.0f);
                livingEntity.m_5496_(soundevent, 1.0f, 1.0f);
                livingEntity.m_20256_(Vec3.f_82478_);
                return true;
            }
            return false;
        };
    }

    public static void register() {
    }
}

