/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.drill;

import com.jozufozu.flywheel.api.Material;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.mojang.math.Quaternion;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.contraptions.actors.flwdata.ActorData;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ActorInstance;
import com.simibubi.create.content.kinetics.drill.DrillBlock;
import com.simibubi.create.foundation.render.AllMaterialSpecs;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class DrillActorInstance
extends ActorInstance {
    ActorData drillHead;
    private final Direction facing;

    public DrillActorInstance(MaterialManager materialManager, VirtualRenderWorld contraption, MovementContext context) {
        super(materialManager, contraption, context);
        Material material = materialManager.defaultSolid().material(AllMaterialSpecs.ACTORS);
        BlockState state = context.state;
        this.facing = (Direction)state.m_61143_((Property)DrillBlock.FACING);
        Direction.Axis axis = this.facing.m_122434_();
        float eulerX = AngleHelper.verticalAngle(this.facing);
        float eulerY = axis == Direction.Axis.Y ? 0.0f : this.facing.m_122435_() + (float)(axis == Direction.Axis.X ? 180 : 0);
        this.drillHead = (ActorData)material.getModel(AllPartialModels.DRILL_HEAD, state).createInstance();
        this.drillHead.setPosition(context.localPos).setBlockLight(this.localBlockLight()).setRotationOffset(0.0f).setRotationAxis(0.0f, 0.0f, 1.0f).setLocalRotation(new Quaternion(eulerX, eulerY, 0.0f, true)).setSpeed(this.getSpeed(this.facing));
    }

    @Override
    public void beginFrame() {
        this.drillHead.setSpeed(this.getSpeed(this.facing));
    }

    protected float getSpeed(Direction facing) {
        if (this.context.contraption.stalled || !VecHelper.isVecPointingTowards(this.context.relativeMotion, facing.m_122424_())) {
            return this.context.getAnimationSpeed();
        }
        return 0.0f;
    }
}

