/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.redstone.displayLink.source;

import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.source.NumericSingleLineDisplaySource;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTargetStats;
import com.simibubi.create.content.trains.display.FlapDisplayBlockEntity;
import com.simibubi.create.content.trains.display.FlapDisplaySection;
import com.simibubi.create.foundation.utility.Components;
import javax.annotation.Nullable;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.SignBlockEntity;

public abstract class PercentOrProgressBarDisplaySource
extends NumericSingleLineDisplaySource {
    @Override
    protected MutableComponent provideLine(DisplayLinkContext context, DisplayTargetStats stats) {
        int i;
        Float currentLevel = this.getProgress(context);
        if (currentLevel == null) {
            return EMPTY_LINE;
        }
        if (!this.progressBarActive(context)) {
            return this.formatNumeric(context, currentLevel);
        }
        String label = context.sourceConfig().m_128461_("Label");
        int labelSize = label.isEmpty() ? 0 : label.length() + 1;
        int length = Math.min(stats.maxColumns() - labelSize, 128);
        if (context.getTargetBlockEntity() instanceof SignBlockEntity) {
            length = (int)((float)length * 6.0f / 9.0f);
        }
        if (context.getTargetBlockEntity() instanceof FlapDisplayBlockEntity) {
            length = this.sizeForWideChars(length);
        }
        int filledLength = (int)(currentLevel.floatValue() * (float)length);
        if (length < 1) {
            return EMPTY_LINE;
        }
        StringBuilder s = new StringBuilder();
        int emptySpaces = length - filledLength;
        for (i = 0; i < filledLength; ++i) {
            s.append("\u2588");
        }
        for (i = 0; i < emptySpaces; ++i) {
            s.append("\u2592");
        }
        return Components.literal(s.toString());
    }

    protected MutableComponent formatNumeric(DisplayLinkContext context, Float currentLevel) {
        return Components.literal(Mth.m_14045_((int)((int)(currentLevel.floatValue() * 100.0f)), (int)0, (int)100) + "%");
    }

    @Nullable
    protected abstract Float getProgress(DisplayLinkContext var1);

    protected abstract boolean progressBarActive(DisplayLinkContext var1);

    @Override
    protected String getFlapDisplayLayoutName(DisplayLinkContext context) {
        return !this.progressBarActive(context) ? super.getFlapDisplayLayoutName(context) : "Progress";
    }

    @Override
    protected FlapDisplaySection createSectionForValue(DisplayLinkContext context, int size) {
        return !this.progressBarActive(context) ? super.createSectionForValue(context, size) : new FlapDisplaySection((float)size * 7.0f, "pixel", false, false).wideFlaps();
    }

    private int sizeForWideChars(int size) {
        return (int)((float)size * 7.0f / 9.0f);
    }
}

