/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.entity;

import com.simibubi.create.CreateClient;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlock;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageBogey;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.entity.TrainIconType;
import com.simibubi.create.content.trains.entity.TravellingPoint;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class TrainPacket
extends SimplePacketBase {
    UUID trainId;
    Train train;
    boolean add;

    public TrainPacket(Train train, boolean add) {
        this.train = train;
        this.add = add;
    }

    public TrainPacket(FriendlyByteBuf buffer) {
        int i;
        this.add = buffer.readBoolean();
        this.trainId = buffer.m_130259_();
        if (!this.add) {
            return;
        }
        UUID owner = null;
        if (buffer.readBoolean()) {
            owner = buffer.m_130259_();
        }
        ArrayList<Carriage> carriages = new ArrayList<Carriage>();
        ArrayList<Integer> carriageSpacing = new ArrayList<Integer>();
        int size = buffer.m_130242_();
        for (i = 0; i < size; ++i) {
            Couple<Object> bogies = Couple.create(null, null);
            for (boolean isFirst : Iterate.trueAndFalse) {
                if (!isFirst && !buffer.readBoolean()) continue;
                AbstractBogeyBlock type = (AbstractBogeyBlock)ForgeRegistries.BLOCKS.getValue(buffer.m_130281_());
                boolean upsideDown = buffer.readBoolean();
                CompoundTag data = buffer.m_130260_();
                bogies.set(isFirst, new CarriageBogey(type, upsideDown, data, new TravellingPoint(), new TravellingPoint()));
            }
            int spacing = buffer.m_130242_();
            carriages.add(new Carriage((CarriageBogey)bogies.getFirst(), (CarriageBogey)bogies.getSecond(), spacing));
        }
        size = buffer.m_130242_();
        for (i = 0; i < size; ++i) {
            carriageSpacing.add(buffer.m_130242_());
        }
        boolean doubleEnded = buffer.readBoolean();
        this.train = new Train(this.trainId, owner, null, carriages, carriageSpacing, doubleEnded);
        this.train.name = Component.Serializer.m_130701_((String)buffer.m_130277_());
        this.train.icon = TrainIconType.byId(buffer.m_130281_());
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.add);
        buffer.m_130077_(this.train.id);
        if (!this.add) {
            return;
        }
        buffer.writeBoolean(this.train.owner != null);
        if (this.train.owner != null) {
            buffer.m_130077_(this.train.owner);
        }
        buffer.m_130130_(this.train.carriages.size());
        for (Carriage carriage : this.train.carriages) {
            for (boolean first : Iterate.trueAndFalse) {
                if (!first) {
                    boolean onTwoBogeys = carriage.isOnTwoBogeys();
                    buffer.writeBoolean(onTwoBogeys);
                    if (!onTwoBogeys) continue;
                }
                CarriageBogey bogey = carriage.bogeys.get(first);
                buffer.m_130085_(RegisteredObjects.getKeyOrThrow(bogey.type));
                buffer.writeBoolean(bogey.upsideDown);
                buffer.m_130079_(bogey.bogeyData);
            }
            buffer.m_130130_(carriage.bogeySpacing);
        }
        buffer.m_130130_(this.train.carriageSpacing.size());
        this.train.carriageSpacing.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130130_(arg_0));
        buffer.writeBoolean(this.train.doubleEnded);
        buffer.m_130070_(Component.Serializer.m_130703_((Component)this.train.name));
        buffer.m_130085_(this.train.icon.id);
    }

    @Override
    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            Map<UUID, Train> trains = CreateClient.RAILWAYS.trains;
            if (this.add) {
                trains.put(this.train.id, this.train);
            } else {
                trains.remove(this.trainId);
            }
        });
        return true;
    }
}

