/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.schedule.condition;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.filter.FilterItem;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.schedule.condition.CargoThresholdCondition;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ItemThresholdCondition
extends CargoThresholdCondition {
    public ItemStack stack = ItemStack.f_41583_;

    @Override
    protected Component getUnit() {
        return Components.literal(this.inStacks() ? "\u25a4" : "");
    }

    @Override
    protected ItemStack getIcon() {
        return this.stack;
    }

    @Override
    protected boolean test(Level level, Train train, CompoundTag context) {
        CargoThresholdCondition.Ops operator = this.getOperator();
        int target = this.getThreshold();
        boolean stacks = this.inStacks();
        int foundItems = 0;
        for (Carriage carriage : train.carriages) {
            IItemHandlerModifiable items = carriage.storage.getItems();
            for (int i = 0; i < items.getSlots(); ++i) {
                ItemStack stackInSlot = items.getStackInSlot(i);
                if (!FilterItem.test(level, stackInSlot, this.stack)) continue;
                if (stacks) {
                    foundItems += stackInSlot.m_41613_() == stackInSlot.m_41741_() ? 1 : 0;
                    continue;
                }
                foundItems += stackInSlot.m_41613_();
            }
        }
        this.requestStatusToUpdate(foundItems, context);
        return operator.test(foundItems, target);
    }

    @Override
    protected void writeAdditional(CompoundTag tag) {
        super.writeAdditional(tag);
        tag.m_128365_("Item", (Tag)this.stack.serializeNBT());
    }

    @Override
    protected void readAdditional(CompoundTag tag) {
        super.readAdditional(tag);
        if (tag.m_128441_("Item")) {
            this.stack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Item"));
        }
    }

    @Override
    public boolean tickCompletion(Level level, Train train, CompoundTag context) {
        return super.tickCompletion(level, train, context);
    }

    @Override
    public void setItem(int slot, ItemStack stack) {
        this.stack = stack;
    }

    @Override
    public ItemStack getItem(int slot) {
        return this.stack;
    }

    @Override
    public List<Component> getTitleAs(String type) {
        return ImmutableList.of((Object)Lang.translateDirect("schedule.condition.threshold.train_holds", Lang.translateDirect("schedule.condition.threshold." + Lang.asId(this.getOperator().name()), new Object[0])), (Object)Lang.translateDirect("schedule.condition.threshold.x_units_of_item", this.getThreshold(), Lang.translateDirect("schedule.condition.threshold." + (this.inStacks() ? "stacks" : "items"), new Object[0]), this.stack.m_41619_() ? Lang.translateDirect("schedule.condition.threshold.anything", new Object[0]) : (this.stack.m_41720_() instanceof FilterItem ? Lang.translateDirect("schedule.condition.threshold.matching_content", new Object[0]) : this.stack.m_41786_())).m_130940_(ChatFormatting.DARK_AQUA));
    }

    private boolean inStacks() {
        return this.intData("Measure") == 1;
    }

    @Override
    public ResourceLocation getId() {
        return Create.asResource("item_threshold");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initConfigurationWidgets(ModularGuiLineBuilder builder) {
        super.initConfigurationWidgets(builder);
        builder.addSelectionScrollInput(71, 50, (i, l) -> i.forOptions((List<? extends Component>)ImmutableList.of((Object)Lang.translateDirect("schedule.condition.threshold.items", new Object[0]), (Object)Lang.translateDirect("schedule.condition.threshold.stacks", new Object[0]))).titled(Lang.translateDirect("schedule.condition.threshold.item_measure", new Object[0])), "Measure");
    }

    @Override
    public MutableComponent getWaitingStatus(Level level, Train train, CompoundTag tag) {
        int lastDisplaySnapshot = this.getLastDisplaySnapshot(tag);
        if (lastDisplaySnapshot == -1) {
            return Components.empty();
        }
        int offset = this.getOperator() == CargoThresholdCondition.Ops.LESS ? -1 : (this.getOperator() == CargoThresholdCondition.Ops.GREATER ? 1 : 0);
        return Lang.translateDirect("schedule.condition.threshold.status", lastDisplaySnapshot, Math.max(0, this.getThreshold() + offset), Lang.translateDirect("schedule.condition.threshold." + (this.inStacks() ? "stacks" : "items"), new Object[0]));
    }
}

