/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.networking;

import com.simibubi.create.AllPackets;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import java.util.HashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public interface ISyncPersistentData {
    public void onPersistentDataUpdated();

    default public void syncPersistentDataWithTracking(Entity self) {
        AllPackets.getChannel().send(PacketDistributor.TRACKING_ENTITY.with(() -> self), (Object)new PersistentDataPacket(self));
    }

    public static class PersistentDataPacket
    extends SimplePacketBase {
        private int entityId;
        private Entity entity;
        private CompoundTag readData;

        public PersistentDataPacket(Entity entity) {
            this.entity = entity;
            this.entityId = entity.m_142049_();
        }

        public PersistentDataPacket(FriendlyByteBuf buffer) {
            this.entityId = buffer.readInt();
            this.readData = buffer.m_130260_();
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.writeInt(this.entityId);
            buffer.m_130079_(this.entity.getPersistentData());
        }

        @Override
        public boolean handle(NetworkEvent.Context context) {
            context.enqueueWork(() -> {
                Entity entityByID = Minecraft.m_91087_().f_91073_.m_6815_(this.entityId);
                CompoundTag data = entityByID.getPersistentData();
                new HashSet(data.m_128431_()).forEach(arg_0 -> ((CompoundTag)data).m_128473_(arg_0));
                data.m_128391_(this.readData);
                if (!(entityByID instanceof ISyncPersistentData)) {
                    return;
                }
                ((ISyncPersistentData)entityByID).onPersistentDataUpdated();
            });
            return true;
        }
    }
}

