/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.infrastructure.gametest.tests;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.content.fluids.hosePulley.HosePulleyFluidHandler;
import com.simibubi.create.content.kinetics.gauge.SpeedGaugeBlockEntity;
import com.simibubi.create.content.kinetics.gauge.StressGaugeBlockEntity;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.infrastructure.gametest.CreateGameTestHelper;
import com.simibubi.create.infrastructure.gametest.GameTestGroup;
import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RedstoneSide;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

@GameTestGroup(path="fluids")
public class TestFluids {
    @GameTest(template="hose_pulley_transfer", timeoutTicks=400)
    public static void hosePulleyTransfer(CreateGameTestHelper helper) {
        BlockPos brokenRedstone = new BlockPos(4, 8, 3);
        BlockState redstone = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)Blocks.f_50088_.m_49966_().m_61124_((Property)RedStoneWireBlock.f_55496_, (Comparable)RedstoneSide.NONE)).m_61124_((Property)RedStoneWireBlock.f_55498_, (Comparable)RedstoneSide.NONE)).m_61124_((Property)RedStoneWireBlock.f_55497_, (Comparable)RedstoneSide.UP)).m_61124_((Property)RedStoneWireBlock.f_55499_, (Comparable)RedstoneSide.SIDE)).m_61124_((Property)RedStoneWireBlock.f_55500_, (Comparable)Integer.valueOf(14));
        helper.m_177252_(brokenRedstone, redstone);
        BlockPos lever = new BlockPos(6, 9, 3);
        helper.m_177421_(lever);
        helper.m_177361_(() -> {
            helper.assertSecondsPassed(15);
            BlockPos filledLowerCorner = new BlockPos(8, 3, 2);
            BlockPos filledUpperCorner = new BlockPos(10, 5, 4);
            BlockPos.m_121940_((BlockPos)filledLowerCorner, (BlockPos)filledUpperCorner).forEach(pos -> helper.m_177208_(Blocks.f_49990_, (BlockPos)pos));
            BlockPos emptiedLowerCorner = new BlockPos(2, 3, 2);
            BlockPos emptiedUpperCorner = new BlockPos(4, 5, 4);
            BlockPos.m_121940_((BlockPos)emptiedLowerCorner, (BlockPos)emptiedUpperCorner).forEach(pos -> helper.m_177208_(Blocks.f_50016_, (BlockPos)pos));
            BlockPos pulleyPos = new BlockPos(8, 7, 4);
            IFluidHandler storage = helper.fluidStorageAt(pulleyPos);
            if (storage instanceof HosePulleyFluidHandler) {
                HosePulleyFluidHandler hose = (HosePulleyFluidHandler)storage;
                SmartFluidTank internalTank = hose.getInternalTank();
                if (!internalTank.drain(1, IFluidHandler.FluidAction.SIMULATE).isEmpty()) {
                    helper.m_177284_("Pulley not empty");
                }
            } else {
                helper.m_177284_("Not a pulley");
            }
        });
    }

    @GameTest(template="in_world_pumping_out")
    public static void inWorldPumpingOutput(CreateGameTestHelper helper) {
        BlockPos pumpPos = new BlockPos(3, 2, 2);
        BlockPos waterPos = pumpPos.m_142125_();
        BlockPos basinPos = pumpPos.m_142126_();
        helper.flipBlock(pumpPos);
        helper.m_177361_(() -> {
            helper.m_177208_(Blocks.f_49990_, waterPos);
            helper.assertTankEmpty(basinPos);
        });
    }

    @GameTest(template="in_world_pumping_in")
    public static void inWorldPumpingPickup(CreateGameTestHelper helper) {
        BlockPos pumpPos = new BlockPos(3, 2, 2);
        BlockPos basinPos = pumpPos.m_142126_();
        BlockPos waterPos = pumpPos.m_142125_();
        FluidStack expectedResult = new FluidStack((Fluid)Fluids.f_76193_, 1000);
        helper.flipBlock(pumpPos);
        helper.m_177361_(() -> {
            helper.m_177208_(Blocks.f_50016_, waterPos);
            helper.assertFluidPresent(expectedResult, basinPos);
        });
    }

    @GameTest(template="steam_engine")
    public static void steamEngine(CreateGameTestHelper helper) {
        BlockPos lever = new BlockPos(4, 3, 3);
        helper.m_177421_(lever);
        BlockPos stressometer = new BlockPos(5, 2, 5);
        BlockPos speedometer = new BlockPos(4, 2, 5);
        helper.m_177361_(() -> {
            StressGaugeBlockEntity stress = (StressGaugeBlockEntity)helper.getBlockEntity((BlockEntityType)AllBlockEntityTypes.STRESSOMETER.get(), stressometer);
            SpeedGaugeBlockEntity speed = (SpeedGaugeBlockEntity)helper.getBlockEntity((BlockEntityType)AllBlockEntityTypes.SPEEDOMETER.get(), speedometer);
            float capacity = stress.getNetworkCapacity();
            helper.assertCloseEnoughTo(capacity, 2048.0);
            float rotationSpeed = Mth.m_14154_((float)speed.getSpeed());
            helper.assertCloseEnoughTo(rotationSpeed, 16.0);
        });
    }

    @GameTest(template="3_pipe_combine", timeoutTicks=400)
    public static void threePipeCombine(CreateGameTestHelper helper) {
        BlockPos tank1Pos = new BlockPos(5, 2, 1);
        BlockPos tank2Pos = tank1Pos.m_142128_();
        BlockPos tank3Pos = tank2Pos.m_142128_();
        long initialContents = helper.getFluidInTanks(tank1Pos, tank2Pos, tank3Pos);
        BlockPos pumpPos = new BlockPos(2, 2, 2);
        helper.flipBlock(pumpPos);
        helper.m_177361_(() -> {
            helper.assertSecondsPassed(13);
            helper.assertTanksEmpty(tank1Pos, tank2Pos, tank3Pos);
            BlockPos outputTankPos = new BlockPos(1, 2, 2);
            long moved = helper.getFluidInTanks(outputTankPos);
            if (moved != initialContents) {
                helper.m_177284_("Wrong amount of fluid amount. expected [%s], got [%s]".formatted(initialContents, moved));
            }
        });
    }

    @GameTest(template="3_pipe_split", timeoutTicks=200)
    public static void threePipeSplit(CreateGameTestHelper helper) {
        BlockPos pumpPos = new BlockPos(2, 2, 2);
        BlockPos tank1Pos = new BlockPos(5, 2, 1);
        BlockPos tank2Pos = tank1Pos.m_142128_();
        BlockPos tank3Pos = tank2Pos.m_142128_();
        BlockPos outputTankPos = new BlockPos(1, 2, 2);
        long totalContents = helper.getFluidInTanks(tank1Pos, tank2Pos, tank3Pos, outputTankPos);
        helper.flipBlock(pumpPos);
        helper.m_177361_(() -> {
            long newTotalContents;
            helper.assertSecondsPassed(7);
            FluidStack contents = helper.getTankContents(outputTankPos);
            if (!contents.isEmpty()) {
                helper.m_177284_("Tank not empty: " + contents.getAmount());
            }
            if ((newTotalContents = helper.getFluidInTanks(tank1Pos, tank2Pos, tank3Pos)) != totalContents) {
                helper.m_177284_("Wrong total fluid amount. expected [%s], got [%s]".formatted(totalContents, newTotalContents));
            }
        });
    }
}

