/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.client;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class TextureCache {
    private static final Map<ItemLike, Set<String>> CACHED_TEXTURES = new HashMap<ItemLike, Set<String>>();

    public static void refresh() {
        CACHED_TEXTURES.clear();
    }

    @Nullable
    public static String getCached(ItemLike block, Predicate<String> texturePredicate) {
        Set<String> list = CACHED_TEXTURES.get(block);
        if (list != null) {
            for (String e : list) {
                if (!texturePredicate.test(e)) continue;
                return e;
            }
        }
        return null;
    }

    public static void add(ItemLike block, String t) {
        CACHED_TEXTURES.computeIfAbsent(block, b -> new HashSet()).add(t);
    }
}

