/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.client.texture_renderer;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.Selene;
import net.mehvahdjukaar.selene.client.texture_renderer.FrameBufferBackedDynamicTexture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.ForgeHooksClient;

public class RenderedTexturesManager {
    private static final List<RenderingData> REQUESTED_FOR_RENDERING = new ArrayList<RenderingData>();
    private static final LoadingCache<ResourceLocation, FrameBufferBackedDynamicTexture> TEXTURE_CACHE = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).removalListener(i -> {
        FrameBufferBackedDynamicTexture value = (FrameBufferBackedDynamicTexture)((Object)((Object)i.getValue()));
        if (value != null) {
            value.close();
        }
    }).build((CacheLoader)new CacheLoader<ResourceLocation, FrameBufferBackedDynamicTexture>(){

        public FrameBufferBackedDynamicTexture load(ResourceLocation key) {
            return null;
        }
    });

    public static void clearCache() {
        TEXTURE_CACHE.invalidateAll();
    }

    public static FrameBufferBackedDynamicTexture getRenderedTexture(ResourceLocation res, int size, Consumer<FrameBufferBackedDynamicTexture> textureDrawingFunction, boolean updateEachFrame) {
        FrameBufferBackedDynamicTexture texture = (FrameBufferBackedDynamicTexture)((Object)TEXTURE_CACHE.getIfPresent((Object)res));
        if (texture == null) {
            texture = new FrameBufferBackedDynamicTexture(res, size);
            TEXTURE_CACHE.put((Object)res, (Object)texture);
            REQUESTED_FOR_RENDERING.add(new RenderingData(res, textureDrawingFunction, updateEachFrame));
        }
        return texture;
    }

    public static FrameBufferBackedDynamicTexture getFlatItemStackTexture(ResourceLocation res, ItemStack stack, int size) {
        return RenderedTexturesManager.getRenderedTexture(res, size, t -> RenderedTexturesManager.drawItem(t, stack), true);
    }

    public static FrameBufferBackedDynamicTexture getFlatItemTexture(Item item, int size, String prefix) {
        return RenderedTexturesManager.getFlatItemTexture(item, size, prefix, null);
    }

    public static FrameBufferBackedDynamicTexture getFlatItemTexture(Item item, int size, String prefix, @Nullable Consumer<NativeImage> postProcessing) {
        ResourceLocation res;
        FrameBufferBackedDynamicTexture texture;
        if (!((String)prefix).isEmpty()) {
            prefix = "/" + (String)prefix;
        }
        if ((texture = (FrameBufferBackedDynamicTexture)((Object)TEXTURE_CACHE.getIfPresent((Object)(res = Selene.res(item.getRegistryName().toString().replace(":", "/") + "/" + size + (String)prefix))))) == null) {
            texture = new FrameBufferBackedDynamicTexture(res, size);
            TEXTURE_CACHE.put((Object)res, (Object)texture);
            Consumer<FrameBufferBackedDynamicTexture> factory = t -> {
                RenderedTexturesManager.drawItem(t, item.m_7968_());
                if (postProcessing != null) {
                    t.download();
                    NativeImage img = t.getPixels();
                    postProcessing.accept(img);
                    t.upload();
                }
            };
            REQUESTED_FOR_RENDERING.add(new RenderingData(res, factory, false));
        }
        return texture;
    }

    public static FrameBufferBackedDynamicTexture getFlatItemTexture(Item item, int size) {
        return RenderedTexturesManager.getFlatItemTexture(item, size, "");
    }

    public static void updateTextures() {
        ListIterator<RenderingData> iter = REQUESTED_FOR_RENDERING.listIterator();
        while (iter.hasNext()) {
            RenderingData data = iter.next();
            FrameBufferBackedDynamicTexture texture = (FrameBufferBackedDynamicTexture)((Object)TEXTURE_CACHE.getIfPresent((Object)data.id));
            if (texture != null) {
                texture.initialized = true;
                data.textureDrawingFunction.accept(texture);
            }
            if (data.animated && texture != null) continue;
            iter.remove();
        }
    }

    public static void drawItem2(FrameBufferBackedDynamicTexture tex, BlockPos mirrorPos, Direction mirrorDir, float partialTicks) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        RenderTarget frameBuffer = tex.getFrameBuffer();
        frameBuffer.m_83954_(Minecraft.f_91002_);
        frameBuffer.m_83947_(true);
        int size = tex.getWidth();
        GameRenderer gameRenderer = mc.f_91063_;
        LevelRenderer levelRenderer = mc.f_91060_;
        PoseStack posestack = RenderSystem.m_157191_();
        posestack.m_85836_();
        RenderSystem.m_157182_();
        RenderSystem.m_69421_((int)16640, (boolean)Minecraft.f_91002_);
        FogRenderer.m_109017_();
        RenderSystem.m_69493_();
        RenderSystem.m_69481_();
        RenderSystem.m_69949_((int)0, (int)0, (int)size, (int)size);
        gameRenderer.m_172718_(1.0f, 0.0f, 0.0f);
        levelRenderer.m_109769_();
        posestack.m_85849_();
        RenderSystem.m_157182_();
        mc.m_91385_().m_83947_(true);
    }

    public static Matrix4f getProjectionMatrix(double pFov, int size, int renderDistance) {
        PoseStack posestack = new PoseStack();
        posestack.m_85850_().m_85861_().m_27624_();
        float zoom = 1.0f;
        float zoomX = 1.0f;
        float zoomY = 1.0f;
        if (zoom != 1.0f) {
            posestack.m_85837_((double)zoomX, (double)(-zoomY), 0.0);
            posestack.m_85841_(zoom, zoom, 1.0f);
        }
        posestack.m_85850_().m_85861_().m_27644_(Matrix4f.m_27625_((double)pFov, (float)((float)size / (float)size), (float)0.05f, (float)((float)renderDistance * 4.0f)));
        return posestack.m_85850_().m_85861_();
    }

    public static void drawItem(FrameBufferBackedDynamicTexture tex, ItemStack stack) {
        Minecraft mc = Minecraft.m_91087_();
        RenderTarget frameBuffer = tex.getFrameBuffer();
        frameBuffer.m_83954_(Minecraft.f_91002_);
        frameBuffer.m_83947_(true);
        int size = 16;
        Matrix4f oldProjection = RenderSystem.m_157192_();
        Matrix4f matrix4f = Matrix4f.m_162203_((float)0.0f, (float)size, (float)0.0f, (float)size, (float)1000.0f, (float)ForgeHooksClient.getGuiFarPlane());
        RenderSystem.m_157425_((Matrix4f)matrix4f);
        PoseStack posestack = RenderSystem.m_157191_();
        posestack.m_85836_();
        posestack.m_166856_();
        posestack.m_85837_(0.0, 0.0, (double)(1000.0f - ForgeHooksClient.getGuiFarPlane()));
        RenderSystem.m_157182_();
        Lighting.m_84931_();
        ItemRenderer itemRenderer = mc.m_91291_();
        itemRenderer.m_115123_(stack, 0, 0);
        posestack.m_85849_();
        RenderSystem.m_157182_();
        RenderSystem.m_157425_((Matrix4f)oldProjection);
        mc.m_91385_().m_83947_(true);
    }

    private record RenderingData(ResourceLocation id, Consumer<FrameBufferBackedDynamicTexture> textureDrawingFunction, boolean animated) {
    }
}

