/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.map;

import java.util.Objects;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.map.type.IMapDecorationType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;

public class CustomMapDecoration {
    private final IMapDecorationType<?, ?> type;
    private Component displayName;
    private byte x;
    private byte y;
    private byte rot;

    public CustomMapDecoration(IMapDecorationType<?, ?> type, byte x, byte y, byte rot, @Nullable Component displayName) {
        this.type = type;
        this.x = x;
        this.y = y;
        this.rot = rot;
        this.displayName = displayName;
    }

    public IMapDecorationType<?, ?> getType() {
        return this.type;
    }

    public byte getX() {
        return this.x;
    }

    public byte getY() {
        return this.y;
    }

    public byte getRot() {
        return this.rot;
    }

    public void setDisplayName(Component displayName) {
        this.displayName = displayName;
    }

    public void setRot(byte rot) {
        this.rot = rot;
    }

    public void setX(byte x) {
        this.x = x;
    }

    public void setY(byte y) {
        this.y = y;
    }

    @Nullable
    public Component getDisplayName() {
        return this.displayName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CustomMapDecoration) {
            CustomMapDecoration mapDecoration = (CustomMapDecoration)obj;
            if (this.type != mapDecoration.type) {
                return false;
            }
            if (this.rot != mapDecoration.rot) {
                return false;
            }
            if (this.x != mapDecoration.x) {
                return false;
            }
            if (this.y != mapDecoration.y) {
                return false;
            }
            return Objects.equals(this.displayName, mapDecoration.displayName);
        }
        return false;
    }

    public int hashCode() {
        int i = this.type.getId().hashCode();
        i = 31 * i + this.x;
        i = 31 * i + this.y;
        i = 31 * i + this.rot;
        return 31 * i + Objects.hashCode(this.displayName);
    }

    public void saveToBuffer(FriendlyByteBuf buffer) {
        buffer.writeByte((int)this.getX());
        buffer.writeByte((int)this.getY());
        buffer.writeByte(this.getRot() & 0xF);
        if (this.getDisplayName() != null) {
            buffer.writeBoolean(true);
            buffer.m_130083_(this.getDisplayName());
        } else {
            buffer.writeBoolean(false);
        }
    }

    public CustomMapDecoration(IMapDecorationType<?, ?> type, FriendlyByteBuf buffer) {
        this(type, buffer.readByte(), buffer.readByte(), (byte)(buffer.readByte() & 0xF), buffer.readBoolean() ? buffer.m_130238_() : null);
    }
}

