/*
 * Decompiled with CFR 0.152.
 */
package jeresources.compatibility;

import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jeresources.api.render.IMobRenderHook;
import jeresources.compatibility.JERAPI;
import jeresources.entry.DungeonEntry;
import jeresources.entry.MobEntry;
import jeresources.entry.PlantEntry;
import jeresources.entry.WorldGenEntry;
import jeresources.registry.DungeonRegistry;
import jeresources.registry.MobRegistry;
import jeresources.registry.PlantRegistry;
import jeresources.registry.WorldGenRegistry;
import jeresources.util.FakeClientLevel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public abstract class CompatBase {
    @Nullable
    private static Level fakeClientLevel = null;

    public static Optional<Level> getServerLevel() {
        Minecraft minecraft = Minecraft.m_91087_();
        return Optional.of(minecraft).map(Minecraft::m_91092_).map(integratedServer -> integratedServer.m_129880_(Level.f_46428_));
    }

    @Nonnull
    public static Level getLevel() {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        if (level != null) {
            return level;
        }
        if (fakeClientLevel == null) {
            fakeClientLevel = new FakeClientLevel();
        }
        return fakeClientLevel;
    }

    public abstract void init(boolean var1);

    protected void registerMob(MobEntry entry) {
        MobRegistry.getInstance().registerMob(entry);
    }

    protected void registerDungeonEntry(DungeonEntry entry) {
        DungeonRegistry.getInstance().registerDungeonEntry(entry);
    }

    protected void registerWorldGen(WorldGenEntry entry) {
        WorldGenRegistry.getInstance().registerEntry(entry);
    }

    protected void registerPlant(PlantEntry entry) {
        PlantRegistry.getInstance().registerPlant(entry);
    }

    protected void registerMobRenderHook(Class<? extends LivingEntity> clazz, IMobRenderHook renderHook) {
        JERAPI.getInstance().getMobRegistry().registerRenderHook(clazz, renderHook);
    }
}

