/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.OutputStream;
import java.net.Proxy;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;

public class Main {
    private static final Logger a = LogUtils.getLogger();

    /*
     * WARNING - void declaration
     */
    @DontObfuscate
    public static void main(String[] $$0) {
        ab.a();
        OptionParser $$1 = new OptionParser();
        OptionSpecBuilder $$2 = $$1.accepts("nogui");
        OptionSpecBuilder $$3 = $$1.accepts("initSettings", "Initializes 'server.properties' and 'eula.txt', then quits");
        OptionSpecBuilder $$4 = $$1.accepts("demo");
        OptionSpecBuilder $$5 = $$1.accepts("bonusChest");
        OptionSpecBuilder $$6 = $$1.accepts("forceUpgrade");
        OptionSpecBuilder $$7 = $$1.accepts("eraseCache");
        OptionSpecBuilder $$8 = $$1.accepts("safeMode", "Loads level with vanilla datapack only");
        AbstractOptionSpec $$9 = $$1.accepts("help").forHelp();
        ArgumentAcceptingOptionSpec $$10 = $$1.accepts("singleplayer").withRequiredArg();
        ArgumentAcceptingOptionSpec $$11 = $$1.accepts("universe").withRequiredArg().defaultsTo((Object)".", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec $$12 = $$1.accepts("world").withRequiredArg();
        ArgumentAcceptingOptionSpec $$13 = $$1.accepts("port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)-1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec $$14 = $$1.accepts("serverId").withRequiredArg();
        OptionSpecBuilder $$15 = $$1.accepts("jfrProfile");
        NonOptionArgumentSpec $$16 = $$1.nonOptions();
        try {
            void $$36;
            boolean $$31;
            OptionSet $$17 = $$1.parse($$0);
            if ($$17.has((OptionSpec)$$9)) {
                $$1.printHelpOn((OutputStream)System.err);
                return;
            }
            q.h();
            if ($$17.has((OptionSpec)$$15)) {
                ate.e.a(atc.b);
            }
            yv.a();
            yv.c();
            ad.l();
            Path $$18 = Paths.get("server.properties", new String[0]);
            acz $$19 = new acz($$18);
            $$19.b();
            Path $$20 = Paths.get("eula.txt", new String[0]);
            yz $$21 = new yz($$20);
            if ($$17.has((OptionSpec)$$3)) {
                a.info("Initialized '{}' and '{}'", (Object)$$18.toAbsolutePath(), (Object)$$20.toAbsolutePath());
                return;
            }
            if (!$$21.a()) {
                a.info("You need to agree to the EULA in order to run the server. Go to eula.txt for more info.");
                return;
            }
            File $$22 = new File((String)$$17.valueOf((OptionSpec)$$11));
            YggdrasilAuthenticationService $$23 = new YggdrasilAuthenticationService(Proxy.NO_PROXY);
            MinecraftSessionService $$24 = $$23.createMinecraftSessionService();
            GameProfileRepository $$25 = $$23.createProfileRepository();
            agj $$26 = new agj($$25, new File($$22, MinecraftServer.g.getName()));
            String $$27 = Optional.ofNullable((String)$$17.valueOf((OptionSpec)$$12)).orElse($$19.a().p);
            dkp $$28 = dkp.a($$22.toPath());
            dkp.a $$29 = $$28.c($$27);
            dkq $$30 = $$29.c();
            if ($$30 != null) {
                if ($$30.d()) {
                    a.info("This world must be opened in an older version (like 1.6.4) to be safely converted");
                    return;
                }
                if (!$$30.q()) {
                    a.info("This world was created by an incompatible version.");
                    return;
                }
            }
            if ($$31 = $$17.has((OptionSpec)$$8)) {
                a.warn("Safe mode active, only vanilla datapack will be loaded");
            }
            afn $$32 = new afn(afb.b, new afq(), new afk($$29.a(dkn.g).toFile(), afo.c));
            try {
                zk.b $$33 = new zk.b($$32, dn.a.b, $$19.a().G, $$31);
                zk $$34 = zk.a($$33, () -> {
                    caj $$1 = $$29.d();
                    return $$1 == null ? caj.a : $$1;
                }, (arg_0, arg_1) -> Main.a($$29, $$17, (OptionSpec)$$4, $$19, (OptionSpec)$$5, arg_0, arg_1), ad.f(), Runnable::run).get();
            }
            catch (Exception $$35) {
                a.warn("Failed to load datapacks, can't proceed with server load. You can either fix your datapacks or reset to vanilla with --safeMode", (Throwable)$$35);
                $$32.close();
                return;
            }
            $$36.a();
            hc.a $$37 = $$36.d();
            $$19.a().a($$37);
            dkv $$38 = $$36.e();
            if ($$17.has((OptionSpec)$$6)) {
                Main.a($$29, ake.a(), $$17.has((OptionSpec)$$7), () -> true, $$38.A());
            }
            $$29.a($$37, $$38);
            final acx $$39 = MinecraftServer.a(arg_0 -> Main.a($$29, $$32, (zk)$$36, $$19, $$24, $$25, $$26, $$17, (OptionSpec)$$10, (OptionSpec)$$13, (OptionSpec)$$4, (OptionSpec)$$14, (OptionSpec)$$2, (OptionSpec)$$16, arg_0));
            Thread $$40 = new Thread("Server Shutdown Thread"){

                @Override
                public void run() {
                    $$39.a(true);
                }
            };
            $$40.setUncaughtExceptionHandler(new t(a));
            Runtime.getRuntime().addShutdownHook($$40);
        }
        catch (Exception $$41) {
            a.error(LogUtils.FATAL_MARKER, "Failed to start the minecraft server", (Throwable)$$41);
        }
    }

    private static void a(dkp.a $$0, DataFixer $$1, boolean $$2, BooleanSupplier $$3, cut $$4) {
        a.info("Forcing world upgrade!");
        avv $$5 = new avv($$0, $$1, $$4, $$2);
        qk $$6 = null;
        while (!$$5.b()) {
            int $$8;
            qk $$7 = $$5.h();
            if ($$6 != $$7) {
                $$6 = $$7;
                a.info($$5.h().getString());
            }
            if (($$8 = $$5.e()) > 0) {
                int $$9 = $$5.f() + $$5.g();
                a.info("{}% completed ({} / {} chunks)...", new Object[]{ajl.d((float)$$9 / (float)$$8 * 100.0f), $$9, $$8});
            }
            if (!$$3.getAsBoolean()) {
                $$5.a();
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static /* synthetic */ acx a(dkp.a $$0, afn $$1, zk $$2, acz $$3, MinecraftSessionService $$4, GameProfileRepository $$5, agj $$6, OptionSet $$7, OptionSpec $$8, OptionSpec $$9, OptionSpec $$10, OptionSpec $$11, OptionSpec $$12, OptionSpec $$13, Thread $$14) {
        boolean $$16;
        acx $$15 = new acx($$14, $$0, $$1, $$2, $$3, ake.a(), $$4, $$5, $$6, aeh::new);
        $$15.d((String)$$7.valueOf($$8));
        $$15.a((Integer)$$7.valueOf($$9));
        $$15.c($$7.has($$10));
        $$15.b((String)$$7.valueOf($$11));
        boolean bl2 = $$16 = !$$7.has($$12) && !$$7.valuesOf($$13).contains("nogui");
        if ($$16 && !GraphicsEnvironment.isHeadless()) {
            $$15.bg();
        }
        return $$15;
    }

    private static /* synthetic */ Pair a(dkp.a $$0, OptionSet $$1, OptionSpec $$2, acz $$3, OptionSpec $$4, aga $$5, caj $$6) {
        cut $$14;
        caz $$13;
        hc.e $$7 = hc.e();
        yq<pd> $$8 = yq.a(ov.a, $$7, $$5);
        dkv $$9 = $$0.a($$8, $$6, $$7.g());
        if ($$9 != null) {
            return Pair.of((Object)$$9, (Object)$$7.f());
        }
        if ($$1.has($$2)) {
            caz $$10 = MinecraftServer.j;
            cut $$11 = cut.a($$7);
        } else {
            acy $$12 = $$3.a();
            $$13 = new caz($$12.p, $$12.o, $$12.z, $$12.n, false, new car(), $$6);
            $$14 = $$1.has($$4) ? $$12.a($$7).j() : $$12.a($$7);
        }
        dkt $$15 = new dkt($$13, $$14, Lifecycle.stable());
        return Pair.of((Object)$$15, (Object)$$7.f());
    }
}

