/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.altar;

import iskallia.vault.altar.RequiredItems;
import iskallia.vault.init.ModConfigs;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.util.INBTSerializable;

public class AltarInfusionRecipe
implements INBTSerializable<CompoundTag> {
    private UUID player;
    private List<RequiredItems> requiredItems;
    private List<RequiredItems> cachedItems;
    private boolean pogInfused;

    public AltarInfusionRecipe(UUID uuid, @Nonnull List<RequiredItems> items, List<RequiredItems> cachedItems, boolean pogInfused) {
        this.player = uuid;
        this.requiredItems = items;
        this.cachedItems = cachedItems == null ? new ArrayList() : cachedItems;
        this.pogInfused = pogInfused;
    }

    public AltarInfusionRecipe(CompoundTag tag) {
        this.deserializeNBT(tag);
    }

    public AltarInfusionRecipe(UUID uuid, List<RequiredItems> items, boolean pogInfused) {
        this(uuid, items, null, pogInfused);
    }

    public AltarInfusionRecipe(ServerPlayer player, BlockPos pos) {
        this(player.m_142081_(), ModConfigs.VAULT_ALTAR_INGREDIENTS.getIngredients(player, pos), false);
    }

    public boolean isPogInfused() {
        return this.pogInfused;
    }

    public void setPogInfused(boolean pogInfused) {
        this.pogInfused = pogInfused;
    }

    public void cacheRequiredItems(List<RequiredItems> newRequirements) {
        this.cachedItems = this.requiredItems;
        this.requiredItems = newRequirements;
    }

    public void revertCache() {
        this.requiredItems = this.cachedItems;
        this.cachedItems = new ArrayList<RequiredItems>();
    }

    public UUID getPlayer() {
        return this.player;
    }

    @Nonnull
    public List<RequiredItems> getRequiredItems() {
        return this.requiredItems;
    }

    public List<RequiredItems> getIncompleteRequiredItems() {
        return this.getRequiredItems().stream().filter(required -> !required.isComplete()).collect(Collectors.toList());
    }

    @Nonnull
    public List<RequiredItems> getCachedItems() {
        return this.cachedItems;
    }

    public boolean isComplete() {
        if (this.requiredItems.isEmpty()) {
            return false;
        }
        for (RequiredItems item : this.requiredItems) {
            if (item.isComplete()) continue;
            return false;
        }
        return true;
    }

    public boolean hasEqualQuantities(AltarInfusionRecipe other) {
        int equals = 0;
        for (int i = 0; i < this.getRequiredItems().size(); ++i) {
            RequiredItems item = this.getRequiredItems().get(i);
            if (item.getCurrentAmount() != other.getRequiredItems().get(i).getCurrentAmount()) continue;
            ++equals;
        }
        return equals == 4;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        ListTag requiredItems = new ListTag();
        ListTag cachedItems = new ListTag();
        for (RequiredItems item : this.getRequiredItems()) {
            requiredItems.add((Object)item.serializeNBT());
        }
        for (RequiredItems item : this.getCachedItems()) {
            cachedItems.add((Object)item.serializeNBT());
        }
        nbt.m_128362_("player", this.getPlayer());
        nbt.m_128365_("requiredItems", (Tag)requiredItems);
        nbt.m_128365_("cachedItems", (Tag)cachedItems);
        nbt.m_128379_("pogInfused", this.pogInfused);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        CompoundTag compound;
        this.player = nbt.m_128342_("player");
        ListTag requiredItemsNBT = nbt.m_128437_("requiredItems", 10);
        ListTag cachedItemsNBT = nbt.m_128437_("cachedItems", 10);
        this.requiredItems = new ArrayList<RequiredItems>();
        this.cachedItems = new ArrayList<RequiredItems>();
        for (Tag tag : requiredItemsNBT) {
            compound = (CompoundTag)tag;
            this.requiredItems.add(new RequiredItems(compound));
        }
        for (Tag tag : cachedItemsNBT) {
            compound = (CompoundTag)tag;
            this.cachedItems.add(new RequiredItems(compound));
        }
        this.pogInfused = nbt.m_128471_("pogInfused");
    }
}

