/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.aura;

import iskallia.vault.aura.AuraProvider;
import iskallia.vault.config.EternalAuraConfig;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ActiveAura {
    private final AuraProvider auraProvider;
    private ResourceKey<Level> worldKey;
    private Vec3 offset;
    private float radius;
    private float radiusSq;

    public ActiveAura(AuraProvider auraProvider) {
        this.auraProvider = auraProvider;
        this.updateFromProvider();
    }

    public void updateFromProvider() {
        this.worldKey = this.auraProvider.getWorld();
        this.offset = this.auraProvider.getLocation();
        this.radius = this.auraProvider.getRadius();
        this.radiusSq = this.radius * this.radius;
    }

    public boolean canPersist() {
        return this.auraProvider.isValid();
    }

    public boolean isAffected(Entity entity) {
        ResourceKey entityWorld = entity.m_20193_().m_46472_();
        if (!this.worldKey.equals((Object)entityWorld)) {
            return false;
        }
        Vec3 pos = entity.m_20182_();
        return this.offset.m_82557_(pos) < (double)this.radiusSq;
    }

    public ResourceKey<Level> getWorldKey() {
        return this.worldKey;
    }

    public Vec3 getOffset() {
        return this.offset;
    }

    public float getRadius() {
        return this.radius;
    }

    public EternalAuraConfig.AuraConfig getAura() {
        return this.auraProvider.getAura();
    }

    public AuraProvider getAuraProvider() {
        return this.auraProvider;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActiveAura that = (ActiveAura)o;
        return this.auraProvider.equals(that.auraProvider);
    }

    public int hashCode() {
        return this.auraProvider.hashCode();
    }
}

