/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.aura;

import iskallia.vault.aura.ActiveAura;
import iskallia.vault.aura.AuraProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class AuraManager {
    private static final AuraManager INSTANCE = new AuraManager();
    private final Map<ResourceKey<Level>, Set<ActiveAura>> activeAuras = new HashMap<ResourceKey<Level>, Set<ActiveAura>>();

    private AuraManager() {
    }

    public static AuraManager getInstance() {
        return INSTANCE;
    }

    @SubscribeEvent
    public static void onTick(TickEvent.WorldTickEvent event) {
        if (event.world.m_5776_() || event.phase != TickEvent.Phase.START) {
            return;
        }
        Set<ActiveAura> auras = AuraManager.INSTANCE.activeAuras.getOrDefault(event.world.m_46472_(), Collections.emptySet());
        if (auras.isEmpty()) {
            return;
        }
        auras.removeIf(aura -> !aura.canPersist());
        auras.forEach(ActiveAura::updateFromProvider);
        auras.forEach(aura -> aura.getAura().onTick(event.world, (ActiveAura)aura));
    }

    public void provideAura(AuraProvider provider) {
        this.activeAuras.computeIfAbsent(provider.getWorld(), key -> new HashSet()).add(new ActiveAura(provider));
    }

    @Nonnull
    public Collection<ActiveAura> getAurasAffecting(Entity entity) {
        Collection worldAuras = this.activeAuras.getOrDefault(entity.m_20193_().m_46472_(), Collections.emptySet());
        if (worldAuras.isEmpty()) {
            return worldAuras;
        }
        return worldAuras.stream().filter(aura -> aura.isAffected(entity)).collect(Collectors.toSet());
    }
}

