/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.aura;

import iskallia.vault.config.EternalAuraConfig;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class AuraProvider {
    private final UUID id;
    private final ResourceKey<Level> world;

    protected AuraProvider(UUID id, ResourceKey<Level> world) {
        this.id = id;
        this.world = world;
    }

    public final ResourceKey<Level> getWorld() {
        return this.world;
    }

    public final UUID getId() {
        return this.id;
    }

    public abstract boolean isValid();

    public abstract Vec3 getLocation();

    public abstract EternalAuraConfig.AuraConfig getAura();

    public float getRadius() {
        return this.getAura().getRadius();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuraProvider that = (AuraProvider)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

