/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.block.entity.AlchemyTableTileEntity;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.util.BlockHelper;
import iskallia.vault.util.VoxelUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class AlchemyTableBlock
extends HorizontalDirectionalBlock
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)5.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    public static final VoxelShape SHAPE2 = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)5.0, (double)15.0);

    public AlchemyTableBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_).m_60978_(0.5f).m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{f_54117_, BlockStateProperties.f_61362_});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        boolean flag = fluidState.m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)super.m_5573_(context).m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(flag));
    }

    @NotNull
    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        if (!pState.m_60710_((LevelReader)pLevel, pCurrentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (((Boolean)pState.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return super.m_7417_(pState, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos);
    }

    @NotNull
    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return VoxelUtils.combineAll(BooleanOp.f_82695_, SHAPE, SHAPE2);
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, Level level, @Nonnull BlockPos pos, @Nonnull Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (!(player instanceof ServerPlayer)) {
            return InteractionResult.SUCCESS;
        }
        ServerPlayer sPlayer = (ServerPlayer)player;
        BlockEntity tile = level.m_7702_(pos);
        if (!(tile instanceof AlchemyTableTileEntity)) {
            return InteractionResult.SUCCESS;
        }
        AlchemyTableTileEntity workbench = (AlchemyTableTileEntity)tile;
        NetworkHooks.openGui((ServerPlayer)sPlayer, (MenuProvider)workbench, buffer -> buffer.m_130064_(pos));
        return InteractionResult.SUCCESS;
    }

    @Nullable
    public <A extends BlockEntity> BlockEntityTicker<A> m_142354_(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<A> type) {
        return BlockHelper.getTicker(type, ModBlocks.ALCHEMY_TABLE_TILE_ENTITY, (level1, blockPos, blockState, alchemyTableTile) -> alchemyTableTile.tick(level1, blockPos, blockState));
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tile;
        if (!state.m_60713_(newState.m_60734_()) && (tile = level.m_7702_(pos)) instanceof AlchemyTableTileEntity) {
            AlchemyTableTileEntity workbench = (AlchemyTableTileEntity)tile;
            Containers.m_19002_((Level)level, (BlockPos)pos, (Container)workbench.getInventory());
            workbench.getInventory().m_6211_();
            level.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ModBlocks.ALCHEMY_TABLE_TILE_ENTITY.m_155264_(pos, state);
    }
}

