/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.block.entity.BountyTableTileEntity;
import iskallia.vault.container.oversized.OverSizedInventory;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModItems;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.tree.ExpertiseTree;
import iskallia.vault.util.EntityHelper;
import iskallia.vault.world.data.BountyData;
import iskallia.vault.world.data.PlayerExpertisesData;
import iskallia.vault.world.data.PlayerVaultStatsData;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BountyBlock
extends HorizontalDirectionalBlock
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);

    public BountyBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_).m_60978_(0.5f).m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)f_54117_, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)f_54117_)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{f_54117_, BlockStateProperties.f_61362_});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        boolean flag = fluidState.m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)super.m_5573_(context).m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(flag));
    }

    @NotNull
    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        if (!pState.m_60710_((LevelReader)pLevel, pCurrentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (((Boolean)pState.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return super.m_7417_(pState, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos);
    }

    @NotNull
    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        OverSizedInventory inventory;
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (!(player instanceof ServerPlayer)) {
            return InteractionResult.SUCCESS;
        }
        ServerPlayer sPlayer = (ServerPlayer)player;
        BlockEntity tile = level.m_7702_(pos);
        if (!(tile instanceof BountyTableTileEntity)) {
            return InteractionResult.SUCCESS;
        }
        BountyTableTileEntity bountyTableTileEntity = (BountyTableTileEntity)tile;
        BountyData data = BountyData.get();
        int vaultLevel = PlayerVaultStatsData.get(sPlayer.m_183503_()).getVaultStats((Player)sPlayer).getVaultLevel();
        ItemStack itemInHand = sPlayer.m_21120_(hand);
        if (itemInHand.m_41720_() == ModItems.LOST_BOUNTY && data.getAllLegendaryFor(sPlayer.m_142081_()).isEmpty()) {
            data.setupLegendary(sPlayer.m_142081_());
            level.m_5594_(null, pos, SoundEvents.f_12275_, SoundSource.BLOCKS, 0.75f, 0.7f);
            if (!sPlayer.m_7500_()) {
                itemInHand.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        if (!bountyTableTileEntity.getInventory().m_7983_() && (inventory = bountyTableTileEntity.getInventory()).m_8020_(0).m_150930_(ModBlocks.BRONZE_COIN_PILE.m_5456_())) {
            inventory.getOverSizedContents().forEach(overSizedStack -> overSizedStack.splitByStackSize().forEach(splitStack -> EntityHelper.giveItem(player, splitStack)));
            inventory.getOverSizedContents().clear();
            player.m_6352_((Component)new TextComponent("Bronze is no longer used to reroll bounties. Removed all existing bronze from your bounty table and placed in your inventory or dropped if your inventory is full.").m_130940_(ChatFormatting.YELLOW), player.m_142081_());
            player.m_5496_(SoundEvents.f_12019_, 0.75f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        ExpertiseTree expertises = PlayerExpertisesData.get(sPlayer.m_183503_()).getExpertises((Player)sPlayer);
        SkillContext context = SkillContext.ofExpertise(sPlayer);
        expertises.sync(context);
        CompoundTag tag = data.getAllBountiesAsTagFor(sPlayer.m_142081_());
        tag.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
        tag.m_128405_("vaultLevel", vaultLevel);
        NetworkHooks.openGui((ServerPlayer)sPlayer, (MenuProvider)bountyTableTileEntity, buffer -> buffer.m_130079_(tag));
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tile;
        if (!state.m_60713_(newState.m_60734_()) && (tile = level.m_7702_(pos)) instanceof BountyTableTileEntity) {
            BountyTableTileEntity bountyTableTileEntity = (BountyTableTileEntity)tile;
            bountyTableTileEntity.getInventory().getOverSizedContents().forEach(overSizedStack -> overSizedStack.splitByStackSize().forEach(splitStack -> Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)splitStack)));
            bountyTableTileEntity.getInventory().m_6211_();
            level.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ModBlocks.BOUNTY_TABLE_TILE_ENTITY.m_155264_(pos, state);
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }
}

