/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.block.entity.CatalystInfusionTableTileEntity;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.util.BlockHelper;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class CatalystInfusionBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;

    public CatalystInfusionBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(1.5f, 6.0f).m_60955_());
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public <A extends BlockEntity> BlockEntityTicker<A> m_142354_(Level world, BlockState state, BlockEntityType<A> blockEntityType) {
        return world.f_46443_ ? null : BlockHelper.getTicker(blockEntityType, ModBlocks.CATALYST_INFUSION_TABLE_TILE_ENTITY, CatalystInfusionTableTileEntity::serverTick);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public VoxelShape m_7952_(BlockState state, BlockGetter world, BlockPos pos) {
        return LecternBlock.f_54470_;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return LecternBlock.f_54472_;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> LecternBlock.f_54474_;
            case Direction.SOUTH -> LecternBlock.f_54476_;
            case Direction.EAST -> LecternBlock.f_54475_;
            case Direction.WEST -> LecternBlock.f_54473_;
            default -> LecternBlock.f_54470_;
        };
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (!(blockEntity instanceof CatalystInfusionTableTileEntity)) {
            return InteractionResult.SUCCESS;
        }
        if (!(player instanceof ServerPlayer)) {
            return InteractionResult.SUCCESS;
        }
        NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)((CatalystInfusionTableTileEntity)blockEntity), buffer -> buffer.m_130064_(pos));
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!state.m_60713_(newState.m_60734_()) && (blockEntity = world.m_7702_(pos)) instanceof CatalystInfusionTableTileEntity) {
            CatalystInfusionTableTileEntity tileEntity = (CatalystInfusionTableTileEntity)blockEntity;
            tileEntity.getItemStackHandlers().forEach(itemStackHandler -> {
                for (int i = 0; i < itemStackHandler.getSlots(); ++i) {
                    Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)itemStackHandler.getStackInSlot(i));
                }
            });
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    public boolean m_7923_(@Nonnull BlockState state) {
        return true;
    }

    @ParametersAreNonnullByDefault
    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    @Nonnull
    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @Nonnull
    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @ParametersAreNonnullByDefault
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ModBlocks.CATALYST_INFUSION_TABLE_TILE_ENTITY.m_155264_(pos, state);
    }
}

