/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.block.CrystalClusterBlock;
import iskallia.vault.block.entity.CrystalBuddingBlockEntity;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.util.BlockHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class CrystalBuddingBlock
extends Block
implements EntityBlock {
    public static final BooleanProperty UNBREAKABLE = BooleanProperty.m_61465_((String)"unbreakable");
    private static final Direction[] DIRECTIONS = Direction.values();

    public CrystalBuddingBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_164531_).m_60977_().m_60918_(SoundType.f_154654_).m_60999_().m_60913_(50.0f, 1200.0f));
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)UNBREAKABLE, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    public PushReaction m_5537_(@Nonnull BlockState blockState) {
        return PushReaction.BLOCK;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (interactionHand == InteractionHand.MAIN_HAND && player.m_7500_()) {
                if (player.m_21205_().m_41720_() == Items.f_42398_) {
                    serverLevel.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)UNBREAKABLE, (Comparable)Boolean.valueOf((Boolean)blockState.m_61143_((Property)UNBREAKABLE) == false)));
                    return InteractionResult.SUCCESS;
                }
                if (player.m_21205_().m_41720_() == Items.f_42499_) {
                    this.growRandom(serverLevel, blockPos, serverLevel.f_46441_);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return super.m_6227_(blockState, level, blockPos, player, interactionHand, blockHitResult);
    }

    @ParametersAreNonnullByDefault
    public void m_6861_(BlockState blockState, Level level, BlockPos blockPos, Block block, BlockPos changedBlockPos, boolean pIsMoving) {
        super.m_6861_(blockState, level, blockPos, block, changedBlockPos, pIsMoving);
        this.checkAndUpdateMissingBlockEntity(level, blockPos);
    }

    @ParametersAreNonnullByDefault
    public void m_7455_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, Random random) {
        this.checkAndUpdateMissingBlockEntity((Level)serverLevel, blockPos);
    }

    public void checkAndScheduleTick(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, Random random) {
        if (!serverLevel.m_183326_().m_183582_(blockPos, (Object)this)) {
            this.m_7458_(blockState, serverLevel, blockPos, random);
        }
    }

    @ParametersAreNonnullByDefault
    public void m_7458_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, Random random) {
        this.growRandom(serverLevel, blockPos, random);
        serverLevel.m_186460_(blockPos, (Block)this, this.getNextUpdateIntervalTicks(random));
    }

    private int getNextUpdateIntervalTicks(Random random) {
        float max = ModConfigs.CRYSTAL_BUDDING.getMaxSecondsBetweenGrowthUpdates();
        float min = ModConfigs.CRYSTAL_BUDDING.getMinSecondsBetweenGrowthUpdates();
        return (int)(Math.max(1.0f, random.nextFloat() * (max - min) + min) * 20.0f);
    }

    public void growRandom(ServerLevel serverLevel, BlockPos blockPos, Random random) {
        Direction validGrowthDirection = this.getValidGrowthDirection(serverLevel, blockPos, random);
        if (validGrowthDirection == null) {
            return;
        }
        BlockPos relativeBlockPos = blockPos.m_142300_(validGrowthDirection);
        BlockState relativeBlockState = serverLevel.m_8055_(relativeBlockPos);
        CrystalClusterBlock block = null;
        if (this.canClusterGrowBeginAtState(relativeBlockState)) {
            block = ModBlocks.SMALL_CRYSTAL_BUD;
        } else if (relativeBlockState.m_60713_((Block)ModBlocks.SMALL_CRYSTAL_BUD) && relativeBlockState.m_61143_((Property)CrystalClusterBlock.FACING) == validGrowthDirection) {
            block = ModBlocks.MEDIUM_CRYSTAL_BUD;
        } else if (relativeBlockState.m_60713_((Block)ModBlocks.MEDIUM_CRYSTAL_BUD) && relativeBlockState.m_61143_((Property)CrystalClusterBlock.FACING) == validGrowthDirection) {
            block = ModBlocks.LARGE_CRYSTAL_BUD;
        } else if (relativeBlockState.m_60713_((Block)ModBlocks.LARGE_CRYSTAL_BUD) && relativeBlockState.m_61143_((Property)CrystalClusterBlock.FACING) == validGrowthDirection) {
            block = ModBlocks.CRYSTAL_CLUSTER;
        }
        if (block != null) {
            serverLevel.m_46597_(relativeBlockPos, (BlockState)((BlockState)block.m_49966_().m_61124_((Property)CrystalClusterBlock.WATERLOGGED, (Comparable)Boolean.valueOf(relativeBlockState.m_60819_().m_76152_() == Fluids.f_76193_))).m_61124_((Property)CrystalClusterBlock.FACING, (Comparable)validGrowthDirection));
        }
    }

    @Nullable
    private Direction getValidGrowthDirection(ServerLevel serverLevel, BlockPos blockPos, Random random) {
        List<Direction> validGrowthDirections = this.getValidGrowthDirections(serverLevel, blockPos);
        return validGrowthDirections.size() < 1 ? null : validGrowthDirections.get(random.nextInt(validGrowthDirections.size()));
    }

    private List<Direction> getValidGrowthDirections(ServerLevel serverLevel, BlockPos blockPos) {
        ArrayList<Direction> result = new ArrayList<Direction>(DIRECTIONS.length);
        for (Direction direction : DIRECTIONS) {
            BlockPos relativeBlockPos = blockPos.m_142300_(direction);
            BlockState relativeBlockState = serverLevel.m_8055_(relativeBlockPos);
            if (!this.canClusterGrowBeginAtState(relativeBlockState) && !this.canClusterGrowContinueAtState(relativeBlockState, direction)) continue;
            for (int i = 0; i < this.getGrowthWeight(relativeBlockState); ++i) {
                result.add(direction);
            }
        }
        return result;
    }

    private boolean canClusterGrowBeginAtState(BlockState blockState) {
        return blockState.m_60795_() || blockState.m_60713_(Blocks.f_49990_) && blockState.m_60819_().m_76186_() == 8;
    }

    private boolean canClusterGrowContinueAtState(BlockState blockState, Direction direction) {
        return (blockState.m_60713_((Block)ModBlocks.SMALL_CRYSTAL_BUD) || blockState.m_60713_((Block)ModBlocks.MEDIUM_CRYSTAL_BUD) || blockState.m_60713_((Block)ModBlocks.LARGE_CRYSTAL_BUD)) && blockState.m_61143_((Property)CrystalClusterBlock.FACING) == direction;
    }

    private int getGrowthWeight(BlockState blockState) {
        if (blockState.m_60713_((Block)ModBlocks.LARGE_CRYSTAL_BUD)) {
            return 8;
        }
        if (blockState.m_60713_((Block)ModBlocks.MEDIUM_CRYSTAL_BUD)) {
            return 4;
        }
        if (blockState.m_60713_((Block)ModBlocks.SMALL_CRYSTAL_BUD)) {
            return 2;
        }
        return 1;
    }

    private void checkAndUpdateMissingBlockEntity(Level level, BlockPos blockPos) {
        level.m_7702_(blockPos);
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{UNBREAKABLE});
    }

    @ParametersAreNonnullByDefault
    public float m_5880_(BlockState blockState, Player player, BlockGetter blockGetter, BlockPos blockPos) {
        return (Boolean)blockState.m_61143_((Property)UNBREAKABLE) != false ? 0.0f : super.m_5880_(blockState, player, blockGetter, blockPos);
    }

    public float getExplosionResistance(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, Explosion explosion) {
        return (Boolean)blockState.m_61143_((Property)UNBREAKABLE) != false ? 3600000.0f : super.getExplosionResistance(blockState, blockGetter, blockPos, explosion);
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : BlockHelper.getTicker(blockEntityType, ModBlocks.CRYSTAL_BUDDING_TILE_ENTITY, CrystalBuddingBlockEntity::serverTick);
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return ModBlocks.CRYSTAL_BUDDING_TILE_ENTITY.m_155264_(blockPos, blockState);
    }
}

