/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.block.entity.DivineAltarTileEntity;
import iskallia.vault.core.vault.influence.VaultGod;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.util.BlockHelper;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DivineAltarBlock
extends Block
implements EntityBlock {
    public static final EnumProperty<VaultGod> GOD = EnumProperty.m_61587_((String)"god", VaultGod.class);
    private static final VoxelShape SHAPE = Stream.of(Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0), Block.m_49796_((double)1.0, (double)16.0, (double)1.0, (double)15.0, (double)18.0, (double)2.0), Block.m_49796_((double)1.0, (double)16.0, (double)14.0, (double)15.0, (double)18.0, (double)15.0), Block.m_49796_((double)14.0, (double)16.0, (double)2.0, (double)15.0, (double)18.0, (double)14.0), Block.m_49796_((double)1.0, (double)16.0, (double)2.0, (double)2.0, (double)18.0, (double)14.0), Block.m_49796_((double)2.0, (double)9.0, (double)2.0, (double)14.0, (double)11.0, (double)14.0), Block.m_49796_((double)3.0, (double)11.0, (double)13.0, (double)13.0, (double)18.0, (double)14.0), Block.m_49796_((double)3.0, (double)11.0, (double)2.0, (double)13.0, (double)18.0, (double)3.0), Block.m_49796_((double)2.0, (double)11.0, (double)2.0, (double)3.0, (double)18.0, (double)14.0), Block.m_49796_((double)13.0, (double)11.0, (double)2.0, (double)14.0, (double)18.0, (double)14.0), Block.m_49796_((double)6.0, (double)2.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public DivineAltarBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76366_).m_60999_().m_60913_(-1.0f, 3600000.0f).m_60955_().m_60953_(state -> 12));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(GOD, (Comparable)((Object)VaultGod.TENOS)));
    }

    @Nullable
    public <A extends BlockEntity> BlockEntityTicker<A> m_142354_(Level level, BlockState state, BlockEntityType<A> blockEntityType) {
        return level.m_5776_() ? BlockHelper.getTicker(blockEntityType, ModBlocks.DIVINE_ALTAR_TILE_ENTITY, DivineAltarTileEntity::tickClient) : BlockHelper.getTicker(blockEntityType, ModBlocks.DIVINE_ALTAR_TILE_ENTITY, DivineAltarTileEntity::tickServer);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{GOD});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ModBlocks.DIVINE_ALTAR_TILE_ENTITY.m_155264_(pPos, pState);
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.CONSUME;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (!(blockEntity instanceof DivineAltarTileEntity)) {
            return InteractionResult.PASS;
        }
        DivineAltarTileEntity tile = (DivineAltarTileEntity)blockEntity;
        boolean mainHandEmpty = player.m_21120_(InteractionHand.MAIN_HAND).m_41619_();
        boolean offHandEmpty = player.m_21120_(InteractionHand.OFF_HAND).m_41619_();
        ItemStack existing = tile.getHeldItem().m_41777_();
        if (offHandEmpty && mainHandEmpty && existing.m_41619_()) {
            return InteractionResult.PASS;
        }
        if (!mainHandEmpty || offHandEmpty) {
            tile.setHeldItem(player.m_21120_(InteractionHand.MAIN_HAND).m_41777_());
            tile.setItemPlacedBy(player.m_142081_());
            player.m_21008_(InteractionHand.MAIN_HAND, existing);
        } else {
            tile.setHeldItem(player.m_21120_(InteractionHand.OFF_HAND).m_41777_());
            tile.setItemPlacedBy(player.m_142081_());
            player.m_21008_(InteractionHand.OFF_HAND, existing);
        }
        tile.ticksToConsume = 40;
        tile.consuming = false;
        world.m_5594_(null, pos, SoundEvents.f_12013_, SoundSource.BLOCKS, 1.0f, 1.0f);
        tile.m_6596_();
        world.m_7260_(pos, tile.m_58900_(), tile.m_58900_(), 3);
        return InteractionResult.CONSUME;
    }
}

