/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import com.google.common.base.Functions;
import iskallia.vault.block.entity.DungeonDoorTileEntity;
import iskallia.vault.block.item.DungeonDoorBlockItem;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.util.BlockHelper;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundClearTitlesPacket;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class DungeonDoorBlock
extends DoorBlock
implements EntityBlock {
    public static final EnumProperty<Type> TYPE = EnumProperty.m_61587_((String)"type", Type.class);

    public DungeonDoorBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76367_).m_60913_(-1.0f, 3600000.0f).m_60918_(SoundType.f_56743_).m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)f_52726_, (Comparable)Direction.NORTH)).m_61124_((Property)f_52727_, (Comparable)Boolean.FALSE)).m_61124_((Property)f_52728_, (Comparable)DoorHingeSide.LEFT)).m_61124_((Property)f_52729_, (Comparable)Boolean.FALSE)).m_61124_((Property)f_52730_, (Comparable)DoubleBlockHalf.LOWER)).m_61124_(TYPE, (Comparable)((Object)Type.SPIDER)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{TYPE});
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.BLOCK;
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return true;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ModBlocks.DUNGEON_DOOR_TILE_ENTITY.m_155264_(pPos, pState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return BlockHelper.getTicker(pBlockEntityType, ModBlocks.DUNGEON_DOOR_TILE_ENTITY, DungeonDoorTileEntity::tick);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Boolean isOpen = (Boolean)state.m_61143_((Property)f_52727_);
        if (!isOpen.booleanValue()) {
            this.m_153165_((Entity)player, world, state, pos, true);
            if (world instanceof ServerLevel) {
                BlockEntity te = state.m_61143_((Property)f_52730_) == DoubleBlockHalf.LOWER ? world.m_7702_(pos) : world.m_7702_(pos.m_7495_());
                this.announceDungeon((ServerLevel)world, (DungeonDoorTileEntity)te);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public void announceDungeon(ServerLevel world, DungeonDoorTileEntity tileEntity) {
        if (tileEntity == null) {
            return;
        }
        Component difficultyDisplay = tileEntity.getDifficulty().getDisplay();
        ClientboundSetTitleTextPacket titlePacket = new ClientboundSetTitleTextPacket(TextComponent.f_131282_);
        ClientboundSetSubtitleTextPacket subtitlePacket = new ClientboundSetSubtitleTextPacket(difficultyDisplay);
        AABB box = new AABB(tileEntity.m_58899_().m_142082_(-15, -15, -15), tileEntity.m_58899_().m_142082_(15, 15, 15));
        world.m_6249_((Entity)null, box, e -> e instanceof ServerPlayer).forEach(entity -> {
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                player.f_8906_.m_141995_((Packet)new ClientboundClearTitlesPacket(true));
                player.f_8906_.m_141995_((Packet)titlePacket);
                player.f_8906_.m_141995_((Packet)subtitlePacket);
            }
        });
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Type type;
        BlockState state = super.m_5573_(context);
        if (state == null) {
            return null;
        }
        CompoundTag nbt = context.m_43722_().m_41783_();
        if (nbt != null && (type = Type.fromString(nbt.m_128461_("type"))) != null) {
            state = (BlockState)state.m_61124_(TYPE, (Comparable)((Object)type));
        }
        return state;
    }

    public void m_49811_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        for (Type type : Type.values()) {
            items.add((Object)DungeonDoorBlockItem.fromType(type));
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        ItemStack itemStack = super.getCloneItemStack(state, target, level, pos, player);
        itemStack.m_41784_().m_128359_("type", ((Type)((Object)state.m_61143_(TYPE))).m_7912_());
        return itemStack;
    }

    public static enum Type implements StringRepresentable
    {
        SPIDER,
        ILLAGER,
        ZOMBIE,
        SKELETON,
        PIGLIN,
        WITCH;

        private static final Map<String, Type> NAME_TO_TYPE;

        public static Type fromString(String name) {
            return NAME_TO_TYPE.get(name.toLowerCase(Locale.ROOT));
        }

        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            NAME_TO_TYPE = Arrays.stream(Type.values()).collect(Collectors.toMap(Type::m_7912_, Functions.identity()));
        }
    }
}

