/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import com.google.common.base.Functions;
import iskallia.vault.block.item.EasterEggBlockItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EasterEggBlock
extends Block {
    public static final VoxelShape SHAPE = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.75, (double)10.0);
    public static final EnumProperty<Color> COLOR = EnumProperty.m_61587_((String)"color", Color.class);

    public EasterEggBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(COLOR, (Comparable)((Object)Color.PINK)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{COLOR});
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public void m_49811_(CreativeModeTab tab, NonNullList<ItemStack> items) {
        for (Color color : Color.values()) {
            items.add((Object)EasterEggBlockItem.fromColor(this, color));
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Color color;
        BlockState blockState = this.m_49966_();
        CompoundTag nbt = context.m_43722_().m_41783_();
        if (nbt != null && (color = Color.fromString(nbt.m_128461_("color"))) != null) {
            blockState = (BlockState)blockState.m_61124_(COLOR, (Comparable)((Object)color));
        }
        return blockState;
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        ItemStack stack = (ItemStack)builder.m_78982_(LootContextParams.f_81463_);
        if (stack != null) {
            drops.add(EasterEggBlockItem.fromColor(this, (Color)((Object)state.m_61143_(COLOR))));
        }
        return drops;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        ItemStack itemStack = super.getCloneItemStack(state, target, level, pos, player);
        itemStack.m_41784_().m_128359_("color", ((Color)((Object)state.m_61143_(COLOR))).m_7912_());
        return itemStack;
    }

    public static enum Color implements StringRepresentable
    {
        PINK,
        YELLOW,
        GREEN,
        PURPLE,
        MAGENTA,
        GOLD;

        private static final Map<String, Color> NAME_TO_TYPE;

        public static Color fromString(String name) {
            return NAME_TO_TYPE.get(name.toLowerCase(Locale.ROOT));
        }

        @Nonnull
        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            NAME_TO_TYPE = Arrays.stream(Color.values()).collect(Collectors.toMap(Color::m_7912_, Functions.identity()));
        }
    }
}

