/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.block.entity.HourglassTileEntity;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.util.MiscUtils;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class HourglassBlock
extends Block
implements EntityBlock {
    private static final Random rand = new Random();
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;

    public HourglassBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76275_, (MaterialColor)MaterialColor.f_76362_).m_60955_().m_60999_().m_60913_(3.0f, 3600000.0f));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        if (pState.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            return ModBlocks.HOURGLASS_TILE_ENTITY.m_155264_(pPos, pState);
        }
        return null;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            BlockState down = world.m_8055_(pos.m_7495_());
            return down.m_60664_(world, player, hand, hit.m_82430_(pos.m_7495_()));
        }
        ItemStack interacted = player.m_21120_(hand);
        return InteractionResult.SUCCESS;
    }

    private void playFullEffects(Level world, BlockPos pos) {
        for (int i = 0; i < 30; ++i) {
            Vec3 offset = MiscUtils.getRandomOffset(pos, rand, 2.0f);
            ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123748_, offset.f_82479_, offset.f_82480_, offset.f_82481_, 3, 0.0, 0.0, 0.0, 1.0);
        }
        world.m_5594_(null, pos, SoundEvents.f_12275_, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    @javax.annotation.Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Level world = context.m_43725_();
        if (world.m_46739_(pos) && world.m_8055_(pos.m_7494_()).m_60629_(context)) {
            return (BlockState)this.m_49966_().m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HALF});
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleBlockHalf half;
        if (!worldIn.m_5776_() && player.m_7500_() && (half = (DoubleBlockHalf)state.m_61143_(HALF)) == DoubleBlockHalf.UPPER && (blockstate = worldIn.m_8055_(blockpos = pos.m_7495_())).m_60734_() == state.m_60734_() && blockstate.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            worldIn.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 35);
            worldIn.m_5898_(player, 2001, blockpos, Block.m_49956_((BlockState)blockstate));
        }
        super.m_5707_(worldIn, pos, state, player);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_(HALF);
        if (facing.m_122434_() == Direction.Axis.Y && half == DoubleBlockHalf.LOWER == (facing == Direction.UP)) {
            return facingState.m_60713_((Block)this) && facingState.m_61143_(HALF) != half ? state : Blocks.f_50016_.m_49966_();
        }
        return half == DoubleBlockHalf.LOWER && facing == Direction.DOWN && !state.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @javax.annotation.Nullable LivingEntity placer, ItemStack stack) {
        worldIn.m_7731_(pos.m_7494_(), (BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity te;
        if (!(state.m_60713_(newState.m_60734_()) && newState.m_155947_() || !((te = HourglassBlock.getBlockTileEntity(world, pos, state)) instanceof HourglassTileEntity) || state.m_61143_(HALF) != DoubleBlockHalf.LOWER)) {
            ItemStack stack = new ItemStack((ItemLike)ModBlocks.HOURGLASS);
            stack.m_41784_().m_128365_("BlockEntityTag", (Tag)te.serializeNBT());
            Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)stack);
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    public static BlockPos getTileEntityPos(BlockState state, BlockPos pos) {
        return state.m_61143_(HALF) == DoubleBlockHalf.UPPER ? pos.m_7495_() : pos;
    }

    public static BlockEntity getBlockTileEntity(Level world, BlockPos pos, BlockState state) {
        BlockPos vendingMachinePos = HourglassBlock.getTileEntityPos(state, pos);
        return world.m_7702_(vendingMachinePos);
    }
}

