/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.VaultMod;
import iskallia.vault.block.base.FacedBlock;
import iskallia.vault.block.entity.IdentificationStandTileEntity;
import iskallia.vault.block.entity.base.BookAnimatingTileEntity;
import iskallia.vault.client.gui.helper.ConfettiParticles;
import iskallia.vault.gear.VaultGearState;
import iskallia.vault.gear.item.IdentifiableItem;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModSounds;
import iskallia.vault.util.BlockHelper;
import iskallia.vault.util.InventoryUtil;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class IdentificationStandBlock
extends FacedBlock
implements EntityBlock {
    public IdentificationStandBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(1.5f, 1200.0f).m_60955_().m_60953_(value -> 9));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return super.m_5940_(pState, pLevel, pPos, pContext);
    }

    public void m_7100_(BlockState blockState, Level level, BlockPos blockPos, Random random) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof IdentificationStandTileEntity) {
            IdentificationStandTileEntity tileEntity = (IdentificationStandTileEntity)blockEntity;
            if (tileEntity.open == 1.0f && level.f_46443_) {
                this.spawnAnimationParticles(blockPos, random);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnAnimationParticles(BlockPos blockPos, Random random) {
        Minecraft minecraft = Minecraft.m_91087_();
        double x = (float)blockPos.m_123341_() + 0.5f;
        double y = (float)blockPos.m_123342_() + 1.25f;
        double z = (float)blockPos.m_123343_() + 0.5f;
        if (random.nextInt(2) == 0) {
            for (int i = 0; i < 10; ++i) {
                Particle particle = minecraft.f_91061_.m_107370_((ParticleOptions)ParticleTypes.f_123760_, x, y, z, (double)(1.5f * (random.nextFloat() - 0.5f)), (double)(0.4f * random.nextFloat()), (double)(1.5f * (random.nextFloat() - 0.5f)));
                if (particle == null) continue;
                int color = random.nextBoolean() ? 16766976 : 2306897;
                particle.m_107257_(40);
                particle.m_107253_((float)(color >>> 16 & 0xFF) / 255.0f, (float)(color >>> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnIdentificationParticles(BlockPos blockPos, Random random) {
        Minecraft minecraft = Minecraft.m_91087_();
        double x = (float)blockPos.m_123341_() + 0.5f;
        double y = (float)blockPos.m_123342_() + 1.25f;
        double z = (float)blockPos.m_123343_() + 0.5f;
        for (int i = 0; i < 50; ++i) {
            Particle particle = minecraft.f_91061_.m_107370_((ParticleOptions)ParticleTypes.f_123815_, x, y, z, (double)(1.05f * (random.nextFloat() - 0.5f)), (double)(0.4f * random.nextFloat()), (double)(1.05f * (random.nextFloat() - 0.5f)));
            if (particle == null) continue;
            int color = ConfettiParticles.PARTICLE_COLORS[random.nextInt(ConfettiParticles.PARTICLE_COLORS.length)];
            particle.m_107257_(35);
            particle.m_107253_((float)(color >>> 16 & 0xFF) / 255.0f, (float)(color >>> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
        }
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState blockState, Level level, @Nonnull BlockPos pos, @Nonnull Player player, InteractionHand hand, BlockHitResult hit) {
        Item serverPlayer;
        boolean identified = false;
        for (ItemStack itemStack : player.m_150109_().f_35974_) {
            IdentifiableItem identifiableItem;
            VaultGearState state;
            Item item = itemStack.m_41720_();
            if (!(item instanceof IdentifiableItem) || (state = (identifiableItem = (IdentifiableItem)item).getState(itemStack)) != VaultGearState.UNIDENTIFIED) continue;
            if (player instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)player;
                identifiableItem.instantIdentify((Player)serverPlayer, itemStack);
            }
            identified = true;
        }
        for (InventoryUtil.ItemAccess itemAccess : InventoryUtil.findAllItemsInMainHand(player)) {
            ItemStack itemStack = itemAccess.getStack();
            serverPlayer = itemStack.m_41720_();
            if (!(serverPlayer instanceof IdentifiableItem)) continue;
            IdentifiableItem identifiableItem = (IdentifiableItem)serverPlayer;
            if (itemStack.m_41613_() > 1) {
                VaultMod.LOGGER.debug("Skipping overstacked item: {}", (Object)itemStack.m_41720_());
                continue;
            }
            VaultGearState state = identifiableItem.getState(itemStack);
            if (state != VaultGearState.UNIDENTIFIED) continue;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer2 = (ServerPlayer)player;
                identifiableItem.instantIdentify((Player)serverPlayer2, itemStack);
                itemAccess.setStack(itemStack);
            }
            identified = true;
        }
        if (identified) {
            level.m_5594_(null, pos, ModSounds.IDENTIFICATION_SFX, SoundSource.BLOCKS, 0.5f, 1.0f);
            if (level.f_46443_) {
                this.spawnIdentificationParticles(pos, level.f_46441_);
            }
            return InteractionResult.SUCCESS;
        }
        level.m_5594_(null, pos, SoundEvents.f_11711_, SoundSource.BLOCKS, 0.5f, 1.0f);
        return InteractionResult.SUCCESS;
    }

    @Override
    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ModBlocks.IDENTIFICATION_STAND_TILE_ENTITY.m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> tileEntityType) {
        return level.f_46443_ ? BlockHelper.getTicker(tileEntityType, ModBlocks.IDENTIFICATION_STAND_TILE_ENTITY, BookAnimatingTileEntity::bookAnimationTick) : super.m_142354_(level, blockState, tileEntityType);
    }
}

