/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.block.LootStatueUpperBlock;
import iskallia.vault.block.entity.LootStatueTileEntity;
import iskallia.vault.container.LootStatueContainer;
import iskallia.vault.container.RenamingContainer;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.util.BlockHelper;
import iskallia.vault.util.RenameType;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class LootStatueBlock
extends Block
implements EntityBlock {
    public static final VoxelShape SHAPE = Shapes.m_83110_((VoxelShape)LootStatueUpperBlock.SHAPE, (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0));
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    protected LootStatueBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.SOUTH));
    }

    public LootStatueBlock() {
        this(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76409_).m_60913_(1.0f, 3600000.0f));
    }

    public <A extends BlockEntity> BlockEntityTicker<A> m_142354_(Level pLevel, BlockState state, BlockEntityType<A> tBlockEntityType) {
        return BlockHelper.getTicker(tBlockEntityType, ModBlocks.LOOT_STATUE_TILE_ENTITY, LootStatueTileEntity::tick);
    }

    public PushReaction m_5537_(BlockState pState) {
        return PushReaction.BLOCK;
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        if (pDirection == Direction.UP && pNeighborState != ModBlocks.LOOT_STATUE_UPPER.m_49966_()) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(pState, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos);
    }

    public void m_6402_(Level pLevel, BlockPos pos, BlockState pState, LivingEntity pPlacer, ItemStack stack) {
        BlockPos blockpos = pos.m_7494_();
        pLevel.m_7731_(blockpos, (BlockState)ModBlocks.LOOT_STATUE_UPPER.m_49966_().m_61124_(LootStatueUpperBlock.HALF, (Comparable)Half.BOTTOM), 3);
        pLevel.m_7731_(blockpos.m_7494_(), (BlockState)ModBlocks.LOOT_STATUE_UPPER.m_49966_().m_61124_(LootStatueUpperBlock.HALF, (Comparable)Half.TOP), 3);
        if (!(pPlacer instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)pPlacer;
        BlockEntity blockEntity = pLevel.m_7702_(pos);
        if (blockEntity instanceof LootStatueTileEntity) {
            LootStatueTileEntity tile = (LootStatueTileEntity)blockEntity;
            if (!stack.m_41782_() || !stack.m_41783_().m_128441_("BlockEntityTag")) {
                final CompoundTag data = new CompoundTag();
                ListTag itemList = new ListTag();
                List<ItemStack> options = ModConfigs.STATUE_LOOT.getOptions();
                for (ItemStack option : options) {
                    itemList.add((Object)option.serializeNBT());
                }
                data.m_128365_("Items", (Tag)itemList);
                data.m_128365_("Position", (Tag)NbtUtils.m_129224_((BlockPos)pos));
                NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)new MenuProvider(){

                    public Component m_5446_() {
                        return new TextComponent("Loot Statue Options");
                    }

                    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player playerEntity) {
                        return new LootStatueContainer(windowId, data);
                    }
                }, buffer -> buffer.m_130079_(data));
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockEntity te = world.m_7702_(pos);
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof LootStatueTileEntity) {
            LootStatueTileEntity statue = (LootStatueTileEntity)blockEntity;
            ItemStack heldItem = player.m_21205_();
            if (player.m_36341_()) {
                ItemStack chip = statue.removeChip();
                if (chip != ItemStack.f_41583_) {
                    if (!player.m_36356_(chip)) {
                        player.m_36176_(chip, false);
                    }
                    return InteractionResult.m_19078_((boolean)world.f_46443_);
                }
                if (heldItem.m_41619_()) {
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        final CompoundTag nbt = new CompoundTag();
                        nbt.m_128405_("RenameType", RenameType.PLAYER_STATUE.ordinal());
                        CompoundTag data = statue.m_187482_();
                        data.m_128365_("Pos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
                        nbt.m_128365_("Data", (Tag)data);
                        NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                            public Component m_5446_() {
                                return new TextComponent("Player Statue");
                            }

                            @NotNull
                            public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player playerEntity) {
                                return new RenamingContainer(windowId, nbt);
                            }
                        }, buffer -> buffer.m_130079_(nbt));
                    }
                    return InteractionResult.m_19078_((boolean)world.f_46443_);
                }
            } else if (heldItem.m_41720_() == ModItems.ACCELERATION_CHIP) {
                if (statue.addChip()) {
                    if (!player.m_150110_().f_35937_) {
                        heldItem.m_41774_(1);
                    }
                    return InteractionResult.m_19078_((boolean)world.f_46443_);
                }
            } else {
                BlockItem bi;
                Item chip = heldItem.m_41720_();
                if (chip instanceof BlockItem && (bi = (BlockItem)chip).m_40614_() instanceof SlabBlock) {
                    ItemStack s = heldItem.m_41777_();
                    s.m_41764_(1);
                    statue.setStand(heldItem, bi);
                    world.m_5594_(null, pos, bi.m_40614_().m_49966_().m_60827_().m_56777_(), SoundSource.PLAYERS, 0.6f, 1.2f);
                    return InteractionResult.m_19078_((boolean)world.f_46443_);
                }
                if (world.f_46443_) {
                    statue.wobble();
                }
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
        }
        return super.m_6227_(state, world, pos, player, handIn, hit);
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ModBlocks.LOOT_STATUE_TILE_ENTITY.m_155264_(pPos, pState);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Level world = context.m_43725_();
        if (pos.m_123342_() < world.m_151558_() - 3 && world.m_8055_(pos.m_6630_(1)).m_60629_(context) && world.m_8055_(pos.m_6630_(2)).m_60629_(context)) {
            return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_());
        }
        return null;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        if (!world.f_46443_) {
            BlockEntity tileEntity = world.m_7702_(pos);
            ItemStack itemStack = new ItemStack((ItemLike)this);
            if (tileEntity instanceof LootStatueTileEntity) {
                LootStatueTileEntity tile = (LootStatueTileEntity)tileEntity;
                CompoundTag stackNBT = new CompoundTag();
                stackNBT.m_128365_("BlockEntityTag", (Tag)tile.m_187482_());
                itemStack.m_41751_(stackNBT);
            }
            ItemEntity itemEntity = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, itemStack);
            itemEntity.m_32060_();
            world.m_7967_((Entity)itemEntity);
        }
        super.m_5707_(world, pos, state, player);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        ItemStack itemstack = super.getCloneItemStack(state, target, world, pos, player);
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof LootStatueTileEntity) {
            LootStatueTileEntity tile = (LootStatueTileEntity)blockEntity;
            CompoundTag stackNBT = new CompoundTag();
            stackNBT.m_128365_("BlockEntityTag", (Tag)tile.m_187482_());
            if (!stackNBT.m_128456_()) {
                itemstack.m_41751_(stackNBT);
            }
        }
        return itemstack;
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        return List.of();
    }
}

