/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.block.entity.PylonTileEntity;
import iskallia.vault.core.vault.pylon.PylonBuff;
import iskallia.vault.effect.PylonEffect;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModEffects;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.PylonConsumeParticleMessage;
import iskallia.vault.util.BlockHelper;
import iskallia.vault.world.data.PlayerPylons;
import iskallia.vault.world.data.ServerVaults;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.PacketDistributor;

public class PylonBlock
extends Block
implements EntityBlock {
    private static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)18.0, (double)14.0);

    public PylonBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56743_).m_60913_(-1.0f, 3600000.0f).m_60993_());
        this.m_49959_((BlockState)this.f_49792_.m_61090_());
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    @Nonnull
    public RenderShape m_7514_(@Nonnull BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return ModBlocks.PYLON_TILE_ENTITY.m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@Nonnull Level world, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        return BlockHelper.getTicker(type, ModBlocks.PYLON_TILE_ENTITY, PylonTileEntity::tick);
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        PylonTileEntity pylon;
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof PylonTileEntity && !(pylon = (PylonTileEntity)blockEntity).isConsumed()) {
            if (!world.f_46443_) {
                PlayerPylons.add(ServerVaults.get(player.f_19853_).orElse(null), player, pylon.config);
                pylon.setConsumed(true);
                world.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, 2.0f);
                world.m_5594_(null, pos, SoundEvents.f_11767_, SoundSource.BLOCKS, 1.0f, 2.0f);
                ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new PylonConsumeParticleMessage(new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), player.m_142049_(), pylon.config.getColor()));
                PylonEffect effect = player.m_21023_((MobEffect)ModEffects.PYLON) ? ModEffects.PYLON_OVERFLOW : ModEffects.PYLON;
                effect.setDescription(pylon.config.getDescription());
                Object buff = pylon.config.build();
                Object buffConfig = ((PylonBuff)buff).getConfig();
                int duration = ((PylonBuff.Config)buffConfig).getDuration();
                if (duration > 0) {
                    player.m_7292_(new MobEffectInstance((MobEffect)effect, duration, 60, false, false, true));
                }
                player.m_6352_((Component)new TextComponent("You have used a ").m_7220_((Component)new TextComponent(pylon.config.getDescription()).m_6270_(Style.f_131099_.m_178520_(pylon.config.getColor()))).m_130946_(" Pylon!"), Util.f_137441_);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

