/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.block.entity.ShopPedestalBlockTile;
import iskallia.vault.container.oversized.OverSizedItemStack;
import iskallia.vault.event.event.ShopPedestalPriceEvent;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.util.BlockHelper;
import iskallia.vault.util.InventoryUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ShopPedestalBlock
extends Block
implements EntityBlock,
GameMasterBlock {
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");
    public static final VoxelShape SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0));
    private static Map<Item, CoinDefinition> COIN_DEFINITIONS;

    public ShopPedestalBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76409_).m_60955_().m_60913_(3600000.0f, 3600000.0f));
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(true)));
    }

    @Nullable
    public <A extends BlockEntity> BlockEntityTicker<A> m_142354_(Level p_153212_, BlockState state, BlockEntityType<A> tBlockEntityType) {
        return BlockHelper.getTicker(tBlockEntityType, ModBlocks.SHOP_PEDESTAL_TILE_ENTITY, ShopPedestalBlockTile::tick);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{ACTIVE});
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        return player.m_150110_().f_35937_ && super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public PushReaction m_5537_(BlockState pState) {
        return PushReaction.BLOCK;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ShopPedestalBlockTile tile;
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof ShopPedestalBlockTile && (tile = (ShopPedestalBlockTile)blockEntity).isInitialized() && handIn == InteractionHand.MAIN_HAND) {
            ItemStack offerStack = tile.getOfferStack();
            if (!offerStack.m_41619_()) {
                ShopPedestalPriceEvent event = new ShopPedestalPriceEvent(player, offerStack, tile.getCurrencyStack());
                MinecraftForge.EVENT_BUS.post((Event)event);
                ItemStack currency = event.getCost();
                return player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).map(itemHandler -> {
                    List<InventoryUtil.ItemAccess> allItems = List.of();
                    if (!player.m_7500_() && !this.hasEnoughCurrency(allItems = InventoryUtil.findAllItems(player), currency)) {
                        if (worldIn.f_46443_) {
                            player.m_5661_((Component)new TranslatableComponent("message.the_vault.shop_pedestal.fail", new Object[]{currency.m_41786_()}), true);
                        }
                        return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
                    }
                    if (!worldIn.f_46443_) {
                        if (!player.m_7500_()) {
                            this.extractCurrency(player, allItems, currency);
                            BlockState inactiveState = (BlockState)state.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false));
                            tile.m_7651_();
                            worldIn.m_46597_(pos, inactiveState);
                        }
                        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)offerStack.m_41777_());
                        worldIn.m_5594_(null, pos, SoundEvents.f_144049_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    } else {
                        if (!player.m_150110_().f_35937_) {
                            tile.m_7651_();
                        }
                        player.m_5661_((Component)new TranslatableComponent("message.the_vault.shop_pedestal.purchase", new Object[]{offerStack.m_41613_(), offerStack.m_41786_(), currency.m_41613_(), currency.m_41786_()}), true);
                    }
                    return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
                }).orElse(InteractionResult.PASS);
            }
            return InteractionResult.PASS;
        }
        if (player.m_150110_().f_35937_) {
            ItemStack o = player.m_21120_(InteractionHand.MAIN_HAND);
            ItemStack c = player.m_21120_(InteractionHand.OFF_HAND);
            if (!c.m_41619_() && !o.m_41619_()) {
                worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(true)));
                BlockEntity blockEntity2 = worldIn.m_7702_(pos);
                if (blockEntity2 instanceof ShopPedestalBlockTile) {
                    ShopPedestalBlockTile tile2 = (ShopPedestalBlockTile)blockEntity2;
                    tile2.setOffer(o.m_41777_(), OverSizedItemStack.of(c.m_41777_()));
                    tile2.m_6596_();
                    return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
                }
                worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false)));
            }
        }
        return InteractionResult.PASS;
    }

    private boolean hasEnoughCurrency(List<InventoryUtil.ItemAccess> allItems, ItemStack currency) {
        return ShopPedestalBlock.getCoinDefinition(currency.m_41720_()).map(priceCoinDefinition -> {
            int priceValue = priceCoinDefinition.coinValue() * currency.m_41613_();
            for (InventoryUtil.ItemAccess itemAccess : allItems) {
                if ((priceValue -= ShopPedestalBlock.getCoinDefinition(itemAccess.getStack().m_41720_()).map(coinDefinition -> coinDefinition.coinValue() * itemAccess.getStack().m_41613_()).orElse(0).intValue()) > 0) continue;
                return true;
            }
            return false;
        }).orElse(false);
    }

    public boolean extractCurrency(Player player, List<InventoryUtil.ItemAccess> allItems, ItemStack price) {
        ShopPedestalBlock.getCoinDefinition(price.m_41720_()).ifPresent(priceCoinDefinition -> {
            int priceValue = priceCoinDefinition.coinValue() * price.m_41613_();
            if ((priceValue = this.deductCoins(allItems, priceValue, (CoinDefinition)priceCoinDefinition)) > 0) {
                priceValue = this.payUsingLowerDenominations(allItems, priceValue, (CoinDefinition)priceCoinDefinition);
                priceValue = this.payUsingHigherDenominations(allItems, priceValue, (CoinDefinition)priceCoinDefinition);
            }
            if (priceValue < 0) {
                int change = -priceValue;
                ShopPedestalBlock.returnChangeToPlayer(player, change);
            }
        });
        return true;
    }

    private static void returnChangeToPlayer(Player player, int change) {
        while (change > 0) {
            for (CoinDefinition definition : COIN_DEFINITIONS.values()) {
                if (definition.coinValue() > change || change / definition.coinValue() >= 9) continue;
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)definition.coinItem(), change / definition.coinValue()));
                change -= definition.coinValue() * (change / definition.coinValue());
            }
        }
    }

    private int payUsingHigherDenominations(List<InventoryUtil.ItemAccess> allItems, int priceValue, CoinDefinition coinDefinition) {
        while (priceValue > 0 && coinDefinition.previousHigherDenomination != null) {
            Optional<CoinDefinition> higherCoinDefinition = ShopPedestalBlock.getCoinDefinition(coinDefinition.previousHigherDenomination);
            if (!higherCoinDefinition.isPresent()) continue;
            coinDefinition = higherCoinDefinition.get();
            priceValue = this.deductCoins(allItems, priceValue, coinDefinition);
        }
        return priceValue;
    }

    private int payUsingLowerDenominations(List<InventoryUtil.ItemAccess> allItems, int priceValue, CoinDefinition coinDefinition) {
        while (priceValue > 0 && coinDefinition.nextLowerDenomination != null) {
            Optional<CoinDefinition> lowerCoinDefinition = ShopPedestalBlock.getCoinDefinition(coinDefinition.nextLowerDenomination);
            if (!lowerCoinDefinition.isPresent()) continue;
            coinDefinition = lowerCoinDefinition.get();
            priceValue = this.deductCoins(allItems, priceValue, coinDefinition);
        }
        return priceValue;
    }

    private int deductCoins(List<InventoryUtil.ItemAccess> allItems, int priceValue, CoinDefinition coinDefinition) {
        for (InventoryUtil.ItemAccess itemAccess : allItems) {
            int countToRemove;
            ItemStack stack = itemAccess.getStack();
            if (stack.m_41720_() != coinDefinition.coinItem() || (countToRemove = (int)Math.ceil((double)Math.min(priceValue, stack.m_41613_() * coinDefinition.coinValue()) / (double)coinDefinition.coinValue())) <= 0) continue;
            itemAccess.setStack(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.m_41613_() - countToRemove)));
            if ((priceValue -= countToRemove * coinDefinition.coinValue()) > 0) continue;
            break;
        }
        return priceValue;
    }

    private static Optional<CoinDefinition> getCoinDefinition(Item coin) {
        if (COIN_DEFINITIONS == null) {
            COIN_DEFINITIONS = new LinkedHashMap<Item, CoinDefinition>();
            COIN_DEFINITIONS.put((Item)ModBlocks.VAULT_BRONZE, new CoinDefinition((Item)ModBlocks.VAULT_BRONZE, (Item)ModBlocks.VAULT_SILVER, null, 1));
            COIN_DEFINITIONS.put((Item)ModBlocks.VAULT_SILVER, new CoinDefinition((Item)ModBlocks.VAULT_SILVER, (Item)ModBlocks.VAULT_GOLD, (Item)ModBlocks.VAULT_BRONZE, 9));
            COIN_DEFINITIONS.put((Item)ModBlocks.VAULT_GOLD, new CoinDefinition((Item)ModBlocks.VAULT_GOLD, (Item)ModBlocks.VAULT_PLATINUM, (Item)ModBlocks.VAULT_SILVER, 81));
            COIN_DEFINITIONS.put((Item)ModBlocks.VAULT_PLATINUM, new CoinDefinition((Item)ModBlocks.VAULT_PLATINUM, null, (Item)ModBlocks.VAULT_GOLD, 729));
        }
        return Optional.ofNullable(COIN_DEFINITIONS.get(coin));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return (Boolean)pState.m_61143_((Property)ACTIVE) != false ? new ShopPedestalBlockTile(pPos, pState) : null;
    }

    private record CoinDefinition(Item coinItem, @Nullable Item previousHigherDenomination, @Nullable Item nextLowerDenomination, int coinValue) {
    }
}

