/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.block.entity.SparkTileEntity;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.init.ModSounds;
import iskallia.vault.network.message.WendarrSparkParticleMessage;
import iskallia.vault.util.BlockHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class SparkBlock
extends Block
implements EntityBlock {
    public static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape SHAPE_GONE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    public static final BooleanProperty EXPENDED = BooleanProperty.m_61465_((String)"expended");

    public SparkBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_((SoundType)ModSounds.VAULT_GET_SOUND_TYPE).m_60913_(350.0f, 5.0f).m_60993_().m_60955_().m_60971_((state, blockGetter, pos) -> false));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)EXPENDED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{EXPENDED});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SparkTileEntity(pos, state);
    }

    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        return level.m_141902_(pos, ModBlocks.SPARK_TILE_ENTITY).map(sparkTileEntity -> Float.valueOf(sparkTileEntity.hasntExpiredYet() ? super.m_5880_(state, player, level, pos) : -1.0f)).orElse(Float.valueOf(-1.0f)).floatValue();
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return BlockHelper.getTicker(type, ModBlocks.SPARK_TILE_ENTITY, SparkTileEntity::tick);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (!level.f_46443_) {
            ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new WendarrSparkParticleMessage(new Vec3((double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f))));
            level.m_5594_(null, pos, SoundEvents.f_11824_, SoundSource.BLOCKS, 0.5f, 1.75f);
            level.m_5594_(null, pos, SoundEvents.f_11983_, SoundSource.BLOCKS, 0.5f, 1.0f);
        }
        return level.m_46597_(pos, ModBlocks.CONVERTED_SPARK.m_49966_());
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return super.getExplosionResistance(state, level, pos, explosion);
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter level, BlockPos pos, Entity entity) {
        return level.m_141902_(pos, ModBlocks.SPARK_TILE_ENTITY).filter(sparkTileEntity -> sparkTileEntity.getLifeTimePercentage() == 0.0f).isEmpty();
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return pLevel.m_141902_(pPos, ModBlocks.SPARK_TILE_ENTITY).map(sparkTileEntity -> sparkTileEntity.getLifeTimePercentage() == 0.0f ? SHAPE_GONE : SHAPE).orElse(SHAPE);
    }
}

