/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.block.entity.SpiritExtractorTileEntity;
import iskallia.vault.container.SpiritExtractorContainer;
import iskallia.vault.entity.entity.SpiritEntity;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModEntities;
import iskallia.vault.util.BlockHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class SpiritExtractorBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private static final String BLOCK_ENTITY_TAG = "BlockEntityTag";

    public SpiritExtractorBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(0.5f).m_60955_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new SpiritExtractorTileEntity(pos, state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState state, BlockEntityType<T> blockEntityType) {
        return BlockHelper.getTicker(blockEntityType, ModBlocks.SPIRIT_EXTRACTOR_TILE_ENTITY, SpiritExtractorTileEntity::tick);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Object e;
        BlockEntity be = level.m_7702_(pos);
        if (!(be instanceof SpiritExtractorTileEntity)) {
            return super.m_6227_(state, level, pos, player, hand, hit);
        }
        SpiritExtractorTileEntity spiritExtractorTile = (SpiritExtractorTileEntity)be;
        if (!player.m_20197_().isEmpty() && (e = player.m_20197_().get(0)) instanceof SpiritEntity) {
            SpiritEntity spirit = (SpiritEntity)e;
            if (level.m_5776_()) {
                return InteractionResult.SUCCESS;
            }
            if (this.hasSpiritAlready(spiritExtractorTile)) {
                return InteractionResult.FAIL;
            }
            spirit.getGameProfile().ifPresent(spiritExtractorTile::setGameProfile);
            spiritExtractorTile.setItems(spirit.getItems());
            spiritExtractorTile.setInventorySnapshot(spirit.getInventorySnapshot());
            spiritExtractorTile.setVaultLevel(spirit.getVaultLevel());
            spiritExtractorTile.setPlayerLevel(spirit.getPlayerLevel());
            spiritExtractorTile.setRecyclable(spirit.isRecyclable());
            spiritExtractorTile.setRescuedBonus(spirit.getRescuedBonus());
            level.m_7260_(pos, state, state, 3);
            spirit.m_142687_(Entity.RemovalReason.DISCARDED);
            return InteractionResult.SUCCESS;
        }
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (player.m_6144_() && player.m_21206_().m_41619_() && player.m_20197_().isEmpty() && spiritExtractorTile.getGameProfile().isPresent()) {
            this.pickupSpirit(player, spiritExtractorTile);
        } else {
            this.openGui(pos, (ServerPlayer)player);
        }
        return InteractionResult.SUCCESS;
    }

    private void pickupSpirit(Player player, SpiritExtractorTileEntity spiritExtractorTile) {
        Entity entity = ModEntities.SPIRIT.m_20592_((ServerLevel)player.f_19853_, null, null, player.m_142538_(), MobSpawnType.EVENT, false, false);
        if (entity instanceof SpiritEntity) {
            SpiritEntity spirit = (SpiritEntity)entity;
            spiritExtractorTile.getGameProfile().ifPresent(spirit::setGameProfile);
            spirit.setVaultLevel(spiritExtractorTile.getVaultLevel());
            spirit.setPlayerLevel(spiritExtractorTile.getPlayerLevel());
            spirit.setItems(spiritExtractorTile.getItems());
            spirit.setInventorySnapshot(spiritExtractorTile.getInventorySnapshot());
            spirit.setRescuedBonus(spiritExtractorTile.getRescuedBonus());
            spirit.putInPlayersHand(player);
            spiritExtractorTile.removeSpirit();
        }
    }

    private void openGui(final BlockPos pos, ServerPlayer player) {
        NetworkHooks.openGui((ServerPlayer)player, (MenuProvider)new MenuProvider(){

            public Component m_5446_() {
                return new TextComponent("Spirit Extractor");
            }

            public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
                return new SpiritExtractorContainer(windowId, inventory, pos);
            }
        }, (BlockPos)pos);
    }

    private boolean hasSpiritAlready(SpiritExtractorTileEntity spiritExtractorTile) {
        return spiritExtractorTile.getGameProfile().isPresent();
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_(BLOCK_ENTITY_TAG) && (blockEntity = level.m_7702_(pos)) instanceof SpiritExtractorTileEntity) {
            SpiritExtractorTileEntity spiritExtractorTile = (SpiritExtractorTileEntity)blockEntity;
            spiritExtractorTile.m_142466_(tag.m_128469_(BLOCK_ENTITY_TAG));
        }
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        BlockEntity blockentity = (BlockEntity)builder.m_78982_(LootContextParams.f_81462_);
        if (blockentity instanceof SpiritExtractorTileEntity) {
            CompoundTag stackNBT = blockentity.m_187482_();
            ItemStack itemStack = new ItemStack((ItemLike)this);
            if (!stackNBT.m_128456_()) {
                itemStack.m_41700_(BLOCK_ENTITY_TAG, (Tag)stackNBT);
            }
            return List.of(itemStack);
        }
        return super.m_7381_(state, builder);
    }
}

