/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.block.base.FacedBlock;
import iskallia.vault.block.entity.ToolStationTileEntity;
import iskallia.vault.init.ModBlocks;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;

public class ToolStationBlock
extends FacedBlock
implements EntityBlock {
    public static VoxelShape SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)1.0, (double)10.0, (double)1.0, (double)15.0, (double)13.0, (double)15.0), (VoxelShape)Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0));

    public ToolStationBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(0.5f).m_60955_());
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState pState, @Nonnull BlockGetter pLevel, @Nonnull BlockPos pPos, @Nonnull CollisionContext pContext) {
        return SHAPE;
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, Level level, @Nonnull BlockPos pos, @Nonnull Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (!(player instanceof ServerPlayer)) {
            return InteractionResult.SUCCESS;
        }
        ServerPlayer sPlayer = (ServerPlayer)player;
        BlockEntity tile = level.m_7702_(pos);
        if (!(tile instanceof ToolStationTileEntity)) {
            return InteractionResult.SUCCESS;
        }
        ToolStationTileEntity toolStationTileEntity = (ToolStationTileEntity)tile;
        NetworkHooks.openGui((ServerPlayer)sPlayer, (MenuProvider)toolStationTileEntity, buffer -> buffer.m_130064_(pos));
        return InteractionResult.SUCCESS;
    }

    @Override
    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tile;
        if (!state.m_60713_(newState.m_60734_()) && (tile = level.m_7702_(pos)) instanceof ToolStationTileEntity) {
            ToolStationTileEntity craftingStation = (ToolStationTileEntity)tile;
            craftingStation.getInventory().getOverSizedContents().forEach(overSizedStack -> overSizedStack.splitByStackSize().forEach(splitStack -> Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)splitStack)));
            Containers.m_19002_((Level)level, (BlockPos)pos, (Container)craftingStation.getResultContainer());
            craftingStation.getInventory().m_6211_();
            craftingStation.getResultContainer().m_6211_();
            level.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    @Nullable
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return ModBlocks.TOOL_STATION_TILE_ENTITY.m_155264_(pos, state);
    }
}

