/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.block.entity.TransmogTableTileEntity;
import iskallia.vault.dynamodel.model.armor.ArmorPieceModel;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModDynamicModels;
import iskallia.vault.patreon.PatreonManager;
import iskallia.vault.patreon.PatreonPlayerData;
import iskallia.vault.patreon.PatreonTier;
import java.util.Collection;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class TransmogTableBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)4.0, (double)11.0, (double)4.0, (double)12.0, (double)13.0, (double)12.0), Block.m_49796_((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0)});

    public TransmogTableBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(0.5f).m_60953_(state -> 1).m_60955_());
    }

    public static boolean canTransmogModel(Player player, Collection<ResourceLocation> discoveredModelIds, ResourceLocation modelId) {
        PatreonPlayerData data = PatreonManager.getInstance().getPlayerData(player.m_142081_());
        return ModDynamicModels.Armor.PIECE_REGISTRY.get(modelId).map(ArmorPieceModel::getArmorModel).map(armorModel -> {
            if (armorModel.equals(ModDynamicModels.Armor.CHAMPION)) {
                return data.isAtLeastTier(PatreonTier.CHAMPION);
            }
            if (armorModel.equals(ModDynamicModels.Armor.GOBLIN)) {
                long id = TransmogTableBlock.hashId(player.m_142081_());
                return data.isAtLeastTier(PatreonTier.GOBLIN);
            }
            return null;
        }).or(() -> ModDynamicModels.Swords.REGISTRY.get(modelId).map(model -> {
            if (model.equals(ModDynamicModels.Swords.GODSWORD)) {
                return data.isAtLeastTier(PatreonTier.CHAMPION);
            }
            return null;
        })).or(() -> ModDynamicModels.Axes.REGISTRY.get(modelId).map(model -> {
            if (model.equals(ModDynamicModels.Axes.GODAXE)) {
                return data.isAtLeastTier(PatreonTier.CHAMPION);
            }
            return null;
        })).orElseGet(() -> discoveredModelIds.contains(modelId));
    }

    private static long hashId(UUID id) {
        return id.getMostSignificantBits() ^ id.getLeastSignificantBits();
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (world.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (!(player instanceof ServerPlayer)) {
            return InteractionResult.SUCCESS;
        }
        ServerPlayer sPlayer = (ServerPlayer)player;
        BlockEntity tile = world.m_7702_(pos);
        if (!(tile instanceof TransmogTableTileEntity)) {
            return InteractionResult.SUCCESS;
        }
        TransmogTableTileEntity transmogTableTileEntity = (TransmogTableTileEntity)tile;
        NetworkHooks.openGui((ServerPlayer)sPlayer, (MenuProvider)transmogTableTileEntity, buffer -> buffer.m_130064_(pos));
        return InteractionResult.SUCCESS;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getDustColor(BlockState state, BlockGetter reader, BlockPos pos) {
        return state.m_60780_((BlockGetter)reader, (BlockPos)pos).f_76396_;
    }

    @Nullable
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return ModBlocks.TRANSMOG_TABLE_TILE_ENTITY.m_155264_(pos, state);
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pState.m_60713_(pNewState.m_60734_())) {
            BlockEntity blockentity = pLevel.m_7702_(pPos);
            if (blockentity instanceof TransmogTableTileEntity) {
                TransmogTableTileEntity transmogTableTileEntity = (TransmogTableTileEntity)blockentity;
                Containers.m_19002_((Level)pLevel, (BlockPos)pPos, (Container)transmogTableTileEntity.getInternalInventory());
                pLevel.m_46717_(pPos, (Block)this);
            }
            super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
        }
    }
}

