/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.block.entity.TrophyTileEntity;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.util.WeekKey;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TrophyBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final VoxelShape SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public TrophyBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76366_).m_60913_(5.0f, 3600000.0f));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ModBlocks.TROPHY_STATUE_TILE_ENTITY.m_155264_(pPos, pState);
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)pContext.m_8125_());
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        if (!world.f_46443_ && stack.m_41782_() && (blockEntity = world.m_7702_(pos)) instanceof TrophyTileEntity) {
            TrophyTileEntity tileEntity = (TrophyTileEntity)blockEntity;
            CompoundTag nbt = stack.m_41784_();
            CompoundTag blockEntityTag = nbt.m_128469_("BlockEntityTag");
            WeekKey week = WeekKey.deserialize(blockEntityTag.m_128469_("trophyWeek"));
            PlayerVaultStatsData.PlayerRecordEntry recordEntry = PlayerVaultStatsData.PlayerRecordEntry.deserialize(blockEntityTag.m_128469_("recordEntry"));
            tileEntity.setWeek(week);
            tileEntity.setRecordEntry(recordEntry);
            tileEntity.m_6596_();
        }
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        if (!world.f_46443_) {
            BlockEntity tileEntity = world.m_7702_(pos);
            ItemStack itemStack = new ItemStack((ItemLike)this);
            if (tileEntity instanceof TrophyTileEntity) {
                TrophyTileEntity tile = (TrophyTileEntity)tileEntity;
                CompoundTag statueNBT = new CompoundTag();
                tile.m_183515_(statueNBT);
                CompoundTag stackNBT = new CompoundTag();
                stackNBT.m_128365_("BlockEntityTag", (Tag)statueNBT);
                itemStack.m_41751_(stackNBT);
            }
            ItemEntity itemEntity = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, itemStack);
            itemEntity.m_32060_();
            world.m_7967_((Entity)itemEntity);
        }
        super.m_5707_(world, pos, state, player);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        ItemStack itemstack = super.getCloneItemStack(state, target, world, pos, player);
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof TrophyTileEntity) {
            TrophyTileEntity tile = (TrophyTileEntity)blockEntity;
            CompoundTag compoundTag = new CompoundTag();
            tile.m_183515_(compoundTag);
            if (!compoundTag.m_128456_()) {
                itemstack.m_41700_("BlockEntityTag", (Tag)compoundTag);
            }
        }
        return itemstack;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_});
    }

    public void m_7100_(BlockState pState, Level pLevel, BlockPos pos, Random rand) {
        if (rand.nextInt(3) == 0) {
            ParticleEngine mgr = Minecraft.m_91087_().f_91061_;
            Vec3 rPos = new Vec3((double)pos.m_123341_() + 0.5 + (double)(rand.nextFloat() - rand.nextFloat()) * (0.1 + (double)rand.nextFloat() * 0.6), (double)pos.m_123342_() + 0.5 + (double)(rand.nextFloat() - rand.nextFloat()) * ((double)rand.nextFloat() * 0.2), (double)pos.m_123343_() + 0.5 + (double)(rand.nextFloat() - rand.nextFloat()) * (0.1 + (double)rand.nextFloat() * 0.6));
            SimpleAnimatedParticle p = (SimpleAnimatedParticle)mgr.m_107370_((ParticleOptions)ParticleTypes.f_123815_, rPos.f_82479_, rPos.f_82480_, rPos.f_82481_, 0.0, 0.0, 0.0);
            if (p != null) {
                p.m_107657_(-3229440);
            }
        }
    }
}

